#include "Mix/Tool/Win32/Core/Graphics/TargetTextureL.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

TargetTextureL* TargetTextureL::CreateInstance( void )
{
	return new TargetTextureL();
}

TargetTextureL::TargetTextureL( void ) :
m_pD3DSurface( NULL )
{
	ZeroMemory( &m_D3DDesc, sizeof( m_D3DDesc ) );
}

TargetTextureL::~TargetTextureL( void )
{
	MIX_RELEASE( m_pD3DSurface );
}

bool TargetTextureL::Lock( const RECT& rect, D3DLOCKED_RECT& info )
{
	if( m_pD3DSurface == NULL )
	{
		return false;
	}

	if( m_pD3DSurface->LockRect( &info, &rect, D3DLOCK_READONLY ) != D3D_OK )
	{
		return false;
	}

	return true;
}

void TargetTextureL::Unlock( void )
{
	if( m_pD3DSurface == NULL )
	{
		return;
	}

	m_pD3DSurface->UnlockRect();
}

unsigned int TargetTextureL::GetWidth( void ) const
{
	return m_D3DDesc.Width;
}

unsigned int TargetTextureL::GetHeight( void ) const
{
	return m_D3DDesc.Height;
}

D3DFORMAT TargetTextureL::GetFormat( void ) const
{
	return m_D3DDesc.Format;
}

IDirect3DBaseTexture9* TargetTextureL::GetTexturePtr( void )
{
	return NULL;
}

IDirect3DSurface9* TargetTextureL::GetSurfacePtr( void )
{
	return m_pD3DSurface;
}

void TargetTextureL::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DSurface );
}

void TargetTextureL::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DSurface = pManager->D3D_CreateTargetSurface( m_D3DDesc );
}

Mix::Tool::Win32::Object::TYPE TargetTextureL::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__TARGET_TEXTURE_L;
}

}}}}
