#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Graphics/DeviceObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class VertexBuffer : public DeviceObject
	{
	private:
		IDirect3DVertexBuffer9* m_pD3DBuffer;
		std::vector<unsigned char> m_Buffer;
		unsigned int m_Stride;
		unsigned int m_Count;
		unsigned int m_Size;
		bool m_bLock;

	public:
		static VertexBuffer* CreateInstance( unsigned int stride, unsigned int count, const void* initialData );

	private:
		VertexBuffer( unsigned int stride, unsigned int count, const void* initialData );
		virtual ~VertexBuffer( void );

		IDirect3DVertexBuffer9* GetInterfacePtr( void );

	public:
		MIX_REFERENCE_METHOD

		void* Lock( void );
		void Unlock( void );

		unsigned int GetStride( void ) const;
		unsigned int GetCount( void ) const;

		const void* GetBuffer( void ) const;
		unsigned int GetBufferSize( void ) const;

	public:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
