#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Graphics/DeviceObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class VertexLayout : public DeviceObject
	{
	private:
		IDirect3DVertexDeclaration9* m_pD3DVertexLayout;

		unsigned int m_Stride;
		std::vector<D3DVERTEXELEMENT9> m_ElementList;

	public:
		static VertexLayout* CreateInstance( const D3DVERTEXELEMENT9* pElements, unsigned int strid );

	private:
		VertexLayout( const D3DVERTEXELEMENT9* pElements, unsigned int stride );
		virtual ~VertexLayout( void );

		IDirect3DVertexDeclaration9* GetInterfacePtr( void );

	public:
		MIX_REFERENCE_METHOD

		unsigned int GetStride( void ) const;
		const std::vector<D3DVERTEXELEMENT9>& GetElementList( void ) const;

	private:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
