#include "Mix/Tool/Win32/Core/Graphics/VertexShader.h"
#include "Mix/Tool/Win32/Core/Graphics/Manager.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

VertexShader* VertexShader::CreateInstance( const void* pBuffer, unsigned int bufferSize )
{
	return new VertexShader( pBuffer, bufferSize );
}

VertexShader::VertexShader( const void* pBuffer, unsigned int bufferSize ) :
m_pD3DVertexShader( NULL )
{
	m_Buffer.resize( bufferSize );
	::CopyMemory( &( m_Buffer[0] ), pBuffer, bufferSize );
}

VertexShader::~VertexShader( void )
{
	MIX_RELEASE( m_pD3DVertexShader );
}

const void* VertexShader::GetBuffer( void ) const
{
	return ( m_Buffer.size() > 0 )? &( m_Buffer[0] ) : NULL;
}

unsigned int VertexShader::GetBufferSize( void ) const
{
	return m_Buffer.size();
}

IDirect3DVertexShader9* VertexShader::GetInterfacePtr( void )
{
	return m_pD3DVertexShader;
}

void VertexShader::OnInvalidate( void )
{
	MIX_RELEASE( m_pD3DVertexShader );
}

void VertexShader::OnValidate( void )
{
	Mix::Tool::Win32::Graphics::Manager* pManager = Manager::GetInstance();
	if( pManager == NULL )
	{
		return;
	}

	m_pD3DVertexShader = pManager->D3D_CreateVertexShader( &( m_Buffer[0] ) );
}

Mix::Tool::Win32::Object::TYPE VertexShader::GetType( void ) const
{
	return Mix::Tool::Win32::Object::GRAPHICS__VERTEX_SHADER;
}

}}}}
