#pragma once

#include <vector>
#include "Mix/Tool/Win32/Core/Graphics/DeviceObject.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{

	class VertexShader : public DeviceObject
	{
	private:
		std::vector<unsigned char> m_Buffer;
		IDirect3DVertexShader9* m_pD3DVertexShader;

	public:
		static VertexShader* CreateInstance( const void* pBuffer, unsigned int bufferSize );

	private:
		VertexShader( const void* pBuffer, unsigned int bufferSize );
		virtual ~VertexShader( void );

	public:
		MIX_REFERENCE_METHOD

		const void* GetBuffer( void ) const;
		unsigned int GetBufferSize( void ) const;

	private:
		IDirect3DVertexShader9* GetInterfacePtr( void );

	private:
		virtual void OnInvalidate( void );
		virtual void OnValidate( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;

		friend class Manager;
	};

}}}}
