#pragma once

#define MIX_OBJECT_TYPE( MyType, BaseClass ) \
	virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const \
	{ \
		return MyType; \
	} \
	virtual bool QueryType( Mix::Tool::Win32::Object::TYPE type ) const \
	{ \
		if( type == MyType ) \
		{ \
			return true; \
		} \
		return BaseClass::QueryType( type ); \
	} \


namespace Mix{ namespace Tool{ namespace Win32{

	class Object
	{
	public:
		enum TYPE
		{
			OBJECT							= 0,
			REFERENCE						= 1,
			COMPONENT						= 2,
			COMPONENT_CONTAINER				= 3,

			DYNAMICS__FACTORY				= 20,
			DYNAMICS__WORLD					= 21,
			DYNAMICS__COLLISION_OBJECT		= 22,
			DYNAMICS__STATIC_PLANE			= 23,
			DYNAMICS__STATIC_MESH			= 24,
			DYNAMICS__SHAPE					= 25,
			DYNAMICS__BOX_SHAPE				= 26,
			DYNAMICS__CAPSULE_SHAPE			= 27,
			DYNAMICS__SPHERE_SHAPE			= 28,
			DYNAMICS__COMPOUND_SHAPE		= 29,
			DYNAMICS__JOINT					= 30,
			DYNAMICS__POINT_JOINT			= 31,
			DYNAMICS__HINGE_JOINT			= 32,
			DYNAMICS__BALL_JOINT			= 33,
			DYNAMICS__RIGID_BODY			= 34,
			DYNAMICS__KINEMATIC_CHARACTER	= 35,
			DYNAMICS__BASIC_DESIGNER		= 36,
			DYNAMICS__MODEL_DESIGNER		= 37,
			DYNAMICS__PART_DESIGNER			= 38,
			DYNAMICS__DESIGN_TERRAIN		= 39,

			FILE__INPUT_STREAM				= 40,
			FILE__OUTPUT_STREAM				= 41,
			FILE__TEMPORARY_STREAM			= 42,

			GRAPHICS__MANAGER				= 60,
			GRAPHICS__DEVICE_OBJECT			= 61,
			GRAPHICS__VERTEX_LAYOUT			= 62,
			GRAPHICS__VERTEX_SHADER			= 63,
			GRAPHICS__PIXEL_SHADER			= 64,
			GRAPHICS__VERTEX_BUFFER			= 65,
			GRAPHICS__INDEX_BUFFER			= 66,
			GRAPHICS__BACK_BUFFER			= 67,
			GRAPHICS__TEXTURE				= 68,
			GRAPHICS__FILE_TEXTURE			= 69,
			GRAPHICS__TARGET_TEXTURE		= 70,
			GRAPHICS__TARGET_TEXTURE_D		= 71,
			GRAPHICS__TARGET_TEXTURE_L		= 72,
			GRAPHICS__CUBE_TEXTURE			= 73,
			GRAPHICS__SWAPCHAIN				= 74,

			GRAPHICS__MATERIAL_SHADER			= 90,
			GRAPHICS__MATERIAL_SLOT				= 91,
			GRAPHICS__MATERIAL					= 92,
			GRAPHICS__BLANK_MESH				= 93,
			GRAPHICS__MESH						= 94,
			GRAPHICS__OPTIMIZE_MESH				= 95,
			GRAPHICS__OBJECT_MESH				= 96,
			GRAPHICS__MAP_MESH					= 97,
			GRAPHICS__MOTION					= 98,
			GRAPHICS__MOTION_CONTROLLER			= 99,
			GRAPHICS__MOTION_CURVE				= 100,
			GRAPHICS__ROOT_MOTION_CURVE			= 101,
			GRAPHICS__NODE						= 102,
			GRAPHICS__SCENE						= 103,
			GRAPHICS__SCENE_OBJECT				= 104,
			GRAPHICS__CAMERA					= 105,
			GRAPHICS__DRAW_OBJECT				= 106,
			GRAPHICS__MODEL						= 107,
			GRAPHICS__OBJECT_MODEL				= 108,
			GRAPHICS__OCTREE_MODEL				= 109,
			GRAPHICS__MAP_MODEL					= 110,
			GRAPHICS__FBX						= 111,
			GRAPHICS__LINE_HELPER				= 112,
			GRAPHICS__POLYGON_DIVIDER			= 113,

			MAP_COLLISION						= 130,
		};

	public:
		virtual ~Object( void );

	public:
		virtual Mix::Tool::Win32::Object::TYPE GetType( void ) const;
		virtual bool QueryType( Mix::Tool::Win32::Object::TYPE type ) const;
	};

}}}
