﻿using System;
using System.Windows.Forms;
using System.ComponentModel;

namespace Mix.Tool.ModelEditor
{
    [ToolboxItem(true)]
    public class FlagsBox : CheckedListBox
    {
        private Mix.Tool.Utility.BindingItemCollection<int> dataSrc = null;
        private Mix.Tool.Dynamics.FlagsGenerator gene = null;

        [Browsable(false)]
        public Mix.Tool.Utility.BindingItemCollection<int> Collection
        {
            get { return this.dataSrc; }
            set
            {
                if (value != this.dataSrc)
                {
                    if (this.dataSrc != null)
                    {
                        this.dataSrc.ListChanged -= new ListChangedEventHandler(this.dataSrc_ListChanged);
                    }

                    this.dataSrc = value;

                    if (this.dataSrc != null)
                    {
                        this.dataSrc.ListChanged += new ListChangedEventHandler(this.dataSrc_ListChanged);
                    }

                    this.UpdateList();
                }
            }
        }

        [Browsable(false)]
        public Mix.Tool.Dynamics.FlagsGenerator Generator
        {
            get { return this.gene; }
            set
            {
                if (this.gene != value)
                {
                    this.gene = value;
                    this.UpdateCheckState();
                }
            }
        }

        protected override void OnItemCheck(ItemCheckEventArgs ice)
        {
            base.OnItemCheck(ice);

            if (this.gene != null)
            {
                string name = this.Items[ice.Index] as string;

                if (ice.NewValue == CheckState.Checked)
                {
                    if (this.gene.Contains(name) == false)
                    {
                        this.gene.Add(name);
                    }
                }
                else if (ice.NewValue == CheckState.Unchecked)
                {
                    this.gene.Remove(name);
                }
            }
            else
            {
                ice.NewValue = CheckState.Unchecked;
            }
        }

        private void dataSrc_ListChanged(object sender, ListChangedEventArgs e)
        {
            this.UpdateList();
        }

        private void UpdateList()
        {
            this.Items.Clear();

            if( this.dataSrc != null )
            {
                foreach (Mix.Tool.Utility.BindingItem<int> item in this.dataSrc)
                {
                    if (item.Available == true)
                    {
                        this.Items.Add(item.Name);
                    }
                }

                this.UpdateCheckState();
            }
        }

        private void UpdateCheckState()
        {
            int itemCount = this.Items.Count;

            if (this.gene != null)
            {
                for (int i = 0; i < itemCount; i++)
                {
                    string attrName = this.Items[i] as string;
                    bool cheked = this.gene.Contains(attrName);

                    this.SetItemChecked(i, cheked);
                }
            }
            else
            {
                for (int i = 0; i < itemCount; i++)
                {
                    this.SetItemChecked(i, false);
                }
            }
        }
    }
}
