﻿using System;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    public partial class JointEditorForm : Mix.Tool.Docking.DockContent
    {
        private Mix.Tool.Dynamics.Design.Part src = null;
        private bool validChangeJoint = true;

        /// <summary>
        /// ソースの取得、または設定
        /// </summary>
        public Mix.Tool.Dynamics.Design.Part Source
        {
            get { return this.src; }
            set
            {
                if (this.src != value)
                {
                    if (((value != null) && (value.Joint != null)) ||
                        (value == null))
                    {
                        this.src = value;

                        if (this.src != null)
                        {
                            this.BeginInitControl();

                            ////////////////////////////////////////////////////////////////////////////////////////////////////

                            Mix.Tool.Dynamics.Joint joint = this.src.Joint;
                            Mix.Tool.Math.Vector jointPivot = this.src.JointPivot;

                            //タイトル
                            if (joint is Mix.Tool.Dynamics.PointJoint)
                            {
                                this.Text = string.Format("{0} - {1}", Properties.Resources.JP_JOINT_EDITOR, Properties.Resources.JP_POINT);
                            }
                            else if (joint is Mix.Tool.Dynamics.HingeJoint)
                            {
                                this.Text = string.Format("{0} - {1}", Properties.Resources.JP_JOINT_EDITOR, Properties.Resources.JP_HINGE);
                            }
                            else if (joint is Mix.Tool.Dynamics.BallJoint)
                            {
                                this.Text = string.Format("{0} - {1}", Properties.Resources.JP_JOINT_EDITOR, Properties.Resources.JP_BALL);
                            }

                            this.pgJoint.SelectedObject = joint;

                            this.nudJPX.Value = Convert.ToDecimal(jointPivot.X);
                            this.nudJPY.Value = Convert.ToDecimal(jointPivot.Y);
                            this.nudJPZ.Value = Convert.ToDecimal(jointPivot.Z);

                            this.cbCollisionDisable.Checked = joint.CollisionDisabled;

                            ////////////////////////////////////////////////////////////////////////////////////////////////////

                            this.EndInitControl();
                        }
                    }
                }

                this.UpdateConntrolState();
            }
        }

        public JointEditorForm()
        {
            InitializeComponent();

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // コントロールの初期化
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            this.UpdateConntrolState();
        }

        private void nudJPX_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateJointPivot();
        }

        private void nudJPY_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateJointPivot();
        }

        private void nudJPZ_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateJointPivot();
        }

        private void cbCollisionDisable_CheckedChanged(object sender, EventArgs e)
        {
            if (this.AvailableSource == true)
            {
                this.src.Joint.CollisionDisabled = this.cbCollisionDisable.Checked;
            }
        }

        private void UpdateConntrolState()
        {
            bool enabled = this.src != null;

            foreach (Control ctrl in this.Controls)
            {
                ctrl.Enabled = enabled;
            }

            if (enabled == true)
            {
                this.Activate();
            }
        }

        private void BeginInitControl()
        {
            this.validChangeJoint = false;
        }

        private void EndInitControl()
        {
            this.validChangeJoint = true;
        }

        private bool AvailableSource
        {
            get
            {
                if ((this.validChangeJoint == false) ||
                    (this.src == null) ||
                    (this.src.Joint == null))
                {
                    return false;
                }

                return true;
            }
        }

        private void UpdateJointPivot()
        {
            if (this.AvailableSource == true)
            {
                Mix.Tool.Math.Vector pivot = new Mix.Tool.Math.Vector();

                pivot.X = (float)Convert.ToDouble(this.nudJPX.Value);
                pivot.Y = (float)Convert.ToDouble(this.nudJPY.Value);
                pivot.Z = (float)Convert.ToDouble(this.nudJPZ.Value);

                this.src.JointPivot = pivot;
            }
        }
    }
}
