﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    /// <summary>
    /// キネマティックキャラクターエディターフォームクラス
    /// </summary>
    public partial class KinematicCharacterEditorForm : Mix.Tool.Docking.DockContent
    {
        private Mix.Tool.Dynamics.Design.Actor src = null;
        private bool validateChangeSrc = true;

        /// <summary>
        /// ソースの取得、または設定
        /// </summary>
        public Mix.Tool.Dynamics.Design.Actor Source
        {
            get { return this.src; }
            set
            {
                this.src = value;

                if (this.src != null)
                {
                    this.BeginInitControl();

                    Mix.Tool.Math.Vector centerPos = this.src.KinematicCharacterCenterPosition;

                    this.pgParam.SelectedObject = this.src.KinematicCharacter;

                    this.nudCX.Value = Convert.ToDecimal(centerPos.X);
                    this.nudCY.Value = Convert.ToDecimal(centerPos.Y);
                    this.nudCZ.Value = Convert.ToDecimal(centerPos.Z);

                    this.cbPhysicsMaterial.Selected = this.src.KinematicCharacter.PhysicsMaterial;

                    this.EndInitControl();
                }

                this.UpdateControlState();
            }
        }

        public KinematicCharacterEditorForm(Project.Dynamics _dynamics)
        {
            InitializeComponent();

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // コントロールの初期化
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            this.cbPhysicsMaterial.DataSource = _dynamics.PhysicsMaterials.DataSource;

            this.UpdateControlState();
        }

        private void nudCX_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateCenterPosition();
        }

        private void nudCY_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateCenterPosition();
        }

        private void nudCZ_ValueChanged(object sender, EventArgs e)
        {
            this.UpdateCenterPosition();
        }

        private void cbPhysicsMaterial_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.AvailableSource == true)
            {
                PhysicsMaterialComboBox cb = sender as PhysicsMaterialComboBox;

                this.src.KinematicCharacter.PhysicsMaterial = cb.Selected;
            }
        }

        private void BeginInitControl()
        {
            this.validateChangeSrc = false;
        }

        private void EndInitControl()
        {
            this.validateChangeSrc = true;
        }

        private bool AvailableSource
        {
            get
            {
                if ((this.validateChangeSrc == false) ||
                    (this.src == null))
                {
                    return false;
                }

                return true;
            }
        }

        private void UpdateControlState()
        {
            bool enabled = this.src != null;

            foreach (Control ctrl in this.Controls)
            {
                ctrl.Enabled = enabled;
            }

            if( enabled == true )
            {
                this.Activate();
            }
        }

        private void UpdateCenterPosition()
        {
            if (this.AvailableSource == true)
            {
                float cx = (float)Convert.ToDouble(this.nudCX.Value);
                float cy = (float)Convert.ToDouble(this.nudCY.Value);
                float cz = (float)Convert.ToDouble(this.nudCZ.Value);

                this.src.KinematicCharacterCenterPosition = new Mix.Tool.Math.Vector(cx, cy, cz, 1.0f);
            }
        }
    }
}
