﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    public partial class LogForm : Mix.Tool.Docking.DockContent
    {
        private Project.Log log = null;

        public LogForm(Project.Log _log)
        {
            InitializeComponent();

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // 初期化
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            this.log = _log;
            this.log.TextChanged += new Project.Log.TextChangedEventHandler(this.log_TextChanged);
            this.textBox.Text = this.log.Text;
            this.textBox.SelectionStart = this.textBox.Text.Length;
            this.textBox.ScrollToCaret();
        }

        private void LogForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.log.TextChanged -= new Project.Log.TextChangedEventHandler(this.log_TextChanged);
        }

        private void LogForm_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                this.textBox.SelectionStart = this.textBox.Text.Length;
                this.textBox.ScrollToCaret();
            }
        }

        private void log_TextChanged(Project.Log.TextChangedEventArgs e)
        {
            if (e.Message.Length > 0)
            {
                this.textBox.AppendText(e.Message + "\r\n");

                if ((this.IsActivated == false) &&
                    (this.Pane.IsAutoHide == true))
                {
                    this.Activate();
                }
           }
            else
            {
                this.textBox.Clear();
            }
        }
    }
}
