﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    public partial class MotionManagerForm : Mix.Tool.Docking.DockContent
    {
        private Mix.Tool.Graphics.ObjectModel model = null;

        public MotionManagerForm( Mix.Tool.Graphics.ObjectModel _model )
        {
            InitializeComponent();

            ////////////////////////////////////////////////////////////////////////////////////////////////////

            this.model = _model;

            ////////////////////////////////////////////////////////////////////////////////////////////////////

            Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformHorizonal>[] dsHoriz = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformHorizonal>[3];
            Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVertical>[] dsVert = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVertical>[3];
            Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>[] dsVectors = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>[6];
            Mix.Tool.Graphics.RootTransformAxis rAxis = this.model.RootTransform.RotationAxis;
            Mix.Tool.Graphics.RootTransformAxis tAxis = this.model.RootTransform.TranslationAxis;
            Mix.Tool.Graphics.RootTransformHorizonal tHoriz = this.model.RootTransform.TranslationHorizonal;
            Mix.Tool.Graphics.RootTransformVertical tVert = this.model.RootTransform.TranslationVertical;

            this.model.RootTransform.BeginUpdate();

            this.CreateNodeList(this.model.RootNode);
            this.cbNode.SelectedItem = this.model.RootTransform.NodeName;

            dsHoriz[0] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformHorizonal>("XY", Mix.Tool.Graphics.RootTransformHorizonal.XY);
            dsHoriz[1] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformHorizonal>("XZ", Mix.Tool.Graphics.RootTransformHorizonal.XZ);
            dsHoriz[2] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformHorizonal>("YZ", Mix.Tool.Graphics.RootTransformHorizonal.YZ);

            dsVert[0] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVertical>("X", Mix.Tool.Graphics.RootTransformVertical.X);
            dsVert[1] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVertical>("Y", Mix.Tool.Graphics.RootTransformVertical.Y);
            dsVert[2] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVertical>("Z", Mix.Tool.Graphics.RootTransformVertical.Z);

            dsVectors[0] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("-X", Mix.Tool.Graphics.RootTransformVector.NegativeX);
            dsVectors[1] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("+X", Mix.Tool.Graphics.RootTransformVector.PositiveX);
            dsVectors[2] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("-Y", Mix.Tool.Graphics.RootTransformVector.NegativeY);
            dsVectors[3] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("+Y", Mix.Tool.Graphics.RootTransformVector.PositiveY);
            dsVectors[4] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("-Z", Mix.Tool.Graphics.RootTransformVector.NegativeZ);
            dsVectors[5] = new Utility.ComboBoxItem<Mix.Tool.Graphics.RootTransformVector>("+Z", Mix.Tool.Graphics.RootTransformVector.PositiveZ);

            this.cbRAxisX.DisplayMember = "Text";
            this.cbRAxisX.ValueMember = "Value";
            this.cbRAxisX.DataSource = dsVectors.Clone();
            this.cbRAxisX.SelectedValue = rAxis.X;

            this.cbRAxisY.DisplayMember = "Text";
            this.cbRAxisY.ValueMember = "Value";
            this.cbRAxisY.DataSource = dsVectors.Clone();
            this.cbRAxisY.SelectedValue = rAxis.Y;

            this.cbRAxisZ.DisplayMember = "Text";
            this.cbRAxisZ.ValueMember = "Value";
            this.cbRAxisZ.DataSource = dsVectors.Clone();
            this.cbRAxisZ.SelectedValue = rAxis.Z;

            this.cbTAxisX.DisplayMember = "Text";
            this.cbTAxisX.ValueMember = "Value";
            this.cbTAxisX.DataSource = dsVectors.Clone();
            this.cbTAxisX.SelectedValue = tAxis.X;

            this.cbTAxisY.DisplayMember = "Text";
            this.cbTAxisY.ValueMember = "Value";
            this.cbTAxisY.DataSource = dsVectors.Clone();
            this.cbTAxisY.SelectedValue = tAxis.Y;

            this.cbTAxisZ.DisplayMember = "Text";
            this.cbTAxisZ.ValueMember = "Value";
            this.cbTAxisZ.DataSource = dsVectors.Clone();
            this.cbTAxisZ.SelectedValue = tAxis.Z;

            this.model.RootTransform.EndUpdate();

            this.cbTHoriz.DisplayMember = "Text";
            this.cbTHoriz.ValueMember = "Value";
            this.cbTHoriz.DataSource = dsHoriz;
            this.cbTHoriz.SelectedValue = tHoriz;

            this.cbTVert.DisplayMember = "Text";
            this.cbTVert.ValueMember = "Value";
            this.cbTVert.DataSource = dsVert;
            this.cbTVert.SelectedValue = tVert;
        }

        private void cbNode_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.model != null)
            {
                this.model.RootTransform.NodeName = this.cbNode.SelectedItem.ToString();
            }
        }

        private void cbRAxisX_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateRotationAxis();
        }

        private void cbRAxisY_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateRotationAxis();
        }

        private void cbRAxisZ_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateRotationAxis();
        }

        private void cbTHoriz_SelectedValueChanged(object sender, EventArgs e)
        {
            if ((this.model != null) &&
                (this.cbTHoriz.SelectedValue != null))
            {
                this.model.RootTransform.TranslationHorizonal = (Mix.Tool.Graphics.RootTransformHorizonal)this.cbTHoriz.SelectedValue;
            }
        }

        private void cbTVert_SelectedValueChanged(object sender, EventArgs e)
        {
            ComboBox cb = sender as ComboBox;

            if ((this.model != null) &&
                (cb.SelectedValue != null))
            {
                this.model.RootTransform.TranslationVertical = (Mix.Tool.Graphics.RootTransformVertical)cb.SelectedValue;
            }
        }

        private void cbTAxisX_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateTranslationAxis();
        }

        private void cbTAxisY_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateTranslationAxis();
        }

        private void cbTAxisZ_SelectedValueChanged(object sender, EventArgs e)
        {
            this.UpdateTranslationAxis();
        }

        #region Private Other Method

        private void CreateNodeList(Mix.Tool.Graphics.Node node)
        {
            this.cbNode.Items.Add(node.Name);

            foreach (Mix.Tool.Graphics.Node childNode in node.Childs)
            {
                this.CreateNodeList(childNode);
            }
        }

        private void UpdateRotationAxis()
        {
            if (this.model == null)
            {
                return;
            }

            if ((this.cbRAxisX.SelectedValue != null) &&
                (this.cbRAxisY.SelectedValue != null) &&
                (this.cbRAxisZ.SelectedValue != null))
            {
                Mix.Tool.Graphics.RootTransformAxis axis = new Mix.Tool.Graphics.RootTransformAxis();

                axis.X = (Mix.Tool.Graphics.RootTransformVector)this.cbRAxisX.SelectedValue;
                axis.Y = (Mix.Tool.Graphics.RootTransformVector)this.cbRAxisY.SelectedValue;
                axis.Z = (Mix.Tool.Graphics.RootTransformVector)this.cbRAxisZ.SelectedValue;

                this.model.RootTransform.RotationAxis = axis;
            }
        }

        private void UpdateTranslationAxis()
        {
            if (this.model == null)
            {
                return;
            }

            if ((this.cbTAxisX.SelectedValue != null) &&
                (this.cbTAxisY.SelectedValue != null) &&
                (this.cbTAxisZ.SelectedValue != null))
            {
                Mix.Tool.Graphics.RootTransformAxis axis = new Mix.Tool.Graphics.RootTransformAxis();

                axis.X = (Mix.Tool.Graphics.RootTransformVector)this.cbTAxisX.SelectedValue;
                axis.Y = (Mix.Tool.Graphics.RootTransformVector)this.cbTAxisY.SelectedValue;
                axis.Z = (Mix.Tool.Graphics.RootTransformVector)this.cbTAxisZ.SelectedValue;

                this.model.RootTransform.TranslationAxis = axis;
            }
        }

        #endregion
    }
}
