﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    public partial class PreferenceForm : Mix.Tool.Docking.DockContent
    {
        private Mix.Tool.Graphics.Manager manager = null;
        private Mix.Tool.Graphics.Scene scene = null;

        public PreferenceForm(Mix.Tool.Graphics.Manager _manager, Mix.Tool.Graphics.Scene _scene)
        {
            InitializeComponent();

            this.manager = _manager;
            this.scene = _scene;

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // タブコントロール
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            this.tabCtrl.SetExMode();

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // シーン
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            //グリッド
            this.nudGridPitch.Value = Convert.ToDecimal(this.scene.Grid.Pitch);
            this.nudGridExtent.Value = Convert.ToDecimal(this.scene.Grid.Extent);

            //ライティング
            this.cpLightAmbient.EditColor = this.scene.Light.AmbientColor.ToColor();
            this.cpLightDiffuse.EditColor = this.scene.Light.DiffuseColor.ToColor();
            this.nudLightShading.Value = Convert.ToDecimal(this.scene.Light.Shading);

            //カメラ
            this.nudCamFovY.Value = Convert.ToDecimal(this.manager.Perspective.FovY);
            this.tbCamFovY.Value = (int)this.manager.Perspective.FovY;
            this.nudCamNearClip.Value = Convert.ToDecimal(this.manager.Perspective.NearZ);
            this.nudCamFarClip.Value = Convert.ToDecimal(this.manager.Perspective.FarZ);

            //リフレクション
            this.tbReflectTex.Text = this.scene.ReflectionTextureFileName;

            //その他
            this.nudAxisScale.Value = Convert.ToDecimal(this.scene.General.AxisScale);
            this.nudJointScale.Value = Convert.ToDecimal(this.scene.General.JointScale);
            this.cbSelectedAD.Checked = this.scene.General.SelectedAlwaysDisplay;

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // テーマ
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            //カラー
            this.cpBGColor.EditColor = this.scene.General.BackgroundColor.ToColor();
            this.cpGridColor.EditColor = this.scene.Grid.Color.ToColor();
            this.cpTextColor.EditColor = this.scene.General.TextColor.ToColor();
            this.cpSelectColor.EditColor = this.scene.General.SelectedColor.ToColor();
            this.cpViewVolumeColor.EditColor = this.scene.General.ViewVolumeColor.ToColor();
            this.cpBoneColor.EditColor = this.scene.General.BoneColor.ToColor();
            this.cpCollisionColor.EditColor = this.scene.General.CollisionColor.ToColor();
            this.cpSensorColor.EditColor = this.scene.General.SensorColor.ToColor();
            this.cpJointAxisColor.EditColor = this.scene.General.JointAxisColor.ToColor();
            this.cpJointPivotColor.EditColor = this.scene.General.JointBallColor.ToColor();
            this.cpJointLimitColor.EditColor = this.scene.General.JointLimitColor.ToColor();

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // コントロール
            ////////////////////////////////////////////////////////////////////////////////////////////////////

            //マウス
            this.nudMouseS.Value = Convert.ToDecimal(this.manager.MouseSensitivity.Scaling);
            this.nudMouseR.Value = Convert.ToDecimal(this.manager.MouseSensitivity.Rotation);
            this.nudMouseT.Value = Convert.ToDecimal(this.manager.MouseSensitivity.Translation);
        }

        #region Page_Scene

        private void nudGridPitch_ValueChanged(object sender, EventArgs e)
        {
            this.scene.Grid.Pitch = (float)Convert.ToDouble(this.nudGridPitch.Value);
        }

        private void nudGridExtent_ValueChanged(object sender, EventArgs e)
        {
            this.scene.Grid.Extent = (float)Convert.ToDouble(this.nudGridExtent.Value);
        }

        private void cpLightAmbient_ChangedEditColor(object sender, EventArgs e)
        {
            this.scene.Light.AmbientColor = new Mix.Tool.Math.Vector(this.cpLightAmbient.EditColor);
        }

        private void cpLightDiffuse_ChangedEditColor(object sender, EventArgs e)
        {
            this.scene.Light.DiffuseColor = new Mix.Tool.Math.Vector(this.cpLightDiffuse.EditColor);
        }

        private void nudLightShading_ValueChanged(object sender, EventArgs e)
        {
            decimal valueD = this.nudLightShading.Value;
            int valueI = Convert.ToInt32(valueD * Convert.ToDecimal(this.tbLightShading.Maximum));

            if (this.tbLightShading.Minimum > valueI)
            {
                valueI = this.tbLightShading.Minimum;
            }
            else if (this.tbLightShading.Maximum < valueI)
            {
                valueI = this.tbLightShading.Maximum;
            }

            this.tbLightShading.Value = valueI;
            this.scene.Light.Shading = (float)Convert.ToDouble(valueD);
        }

        private void tbLightShading_ValueChanged(object sender, EventArgs e)
        {
            decimal value = Convert.ToDecimal(this.tbLightShading.Value) / Convert.ToDecimal(this.tbLightShading.Maximum);

            if (this.nudLightShading.Minimum > value)
            {
                value = this.nudLightShading.Minimum;
            }
            else if (this.nudLightShading.Maximum < value)
            {
                value = this.nudLightShading.Maximum;
            }

            this.nudLightShading.Value = value;
        }

        private void nudCamFovY_ValueChanged(object sender, EventArgs e)
        {
            this.tbCamFovY.Value = Convert.ToInt32(this.nudCamFovY.Value);
            this.manager.Perspective.FovY = (float)Convert.ToDouble(this.nudCamFovY.Value);
        }

        private void tbCamFovY_ValueChanged(object sender, EventArgs e)
        {
            this.nudCamFovY.Value = Convert.ToDecimal(this.tbCamFovY.Value);
        }

        private void nudCamNearClip_ValueChanged(object sender, EventArgs e)
        {
            this.manager.Perspective.NearZ = (float)Convert.ToDouble(this.nudCamNearClip.Value);
        }

        private void nudCamFarClip_ValueChanged(object sender, EventArgs e)
        {
            this.manager.Perspective.FarZ = (float)Convert.ToDouble(this.nudCamFarClip.Value);
        }

        private void tbRefrectTex_TextChanged(object sender, EventArgs e)
        {
            this.scene.ReflectionTextureFileName = this.tbReflectTex.Text;
        }

        private void btRefrectTex_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog dlg = new OpenFileDialog())
            {
                dlg.Filter = Properties.Resources.FILE_FILTER_DDS;
                dlg.FilterIndex = 1;
                dlg.FileName = this.tbReflectTex.Text;

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    this.tbReflectTex.Text = dlg.FileName;
                }
            }
        }

        private void btRefrectTex_Clear_Click(object sender, EventArgs e)
        {
            this.tbReflectTex.Text = "";
        }

        private void nudAxisScale_ValueChanged(object sender, EventArgs e)
        {
            this.scene.General.AxisScale = (float)Convert.ToDouble(this.nudAxisScale.Value);
        }

        private void nudJointScale_ValueChanged(object sender, EventArgs e)
        {
            this.scene.General.JointScale = (float)Convert.ToDouble(this.nudJointScale.Value);
        }

        private void cbNodeSelectedAD_CheckedChanged(object sender, EventArgs e)
        {
            this.scene.General.SelectedAlwaysDisplay = this.cbSelectedAD.Checked;
        }

        #endregion

        #region Page Thema

        private void cpBGColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.BackgroundColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpGridColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.Grid.Color = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpTextColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.TextColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpSelectColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.SelectedColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpViewVolumeColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.ViewVolumeColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpBoneColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.BoneColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpCollisionColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.CollisionColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpSensorColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.SensorColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpJointAxisColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.JointAxisColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpJointPivotColor_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.JointBallColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        private void cpJointLimit_ChangedEditColor(object sender, EventArgs e)
        {
            Mix.Tool.ColorPicker cp = sender as Mix.Tool.ColorPicker;
            this.scene.General.JointLimitColor = new Mix.Tool.Math.Vector(cp.EditColor);
        }

        #endregion

        #region Page Control

        private void nudMouseS_ValueChanged(object sender, EventArgs e)
        {
            decimal valueD = this.nudMouseS.Value;
            int valueI = Convert.ToInt32(valueD * Convert.ToDecimal(this.tbMouseS.Maximum));

            if (this.tbMouseS.Minimum > valueI)
            {
                valueI = this.tbMouseS.Minimum;
            }
            else if (this.tbMouseS.Maximum < valueI)
            {
                valueI = this.tbMouseS.Maximum;
            }

            this.tbMouseS.Value = valueI;
            this.manager.MouseSensitivity.Scaling = (float)Convert.ToDouble(valueD);
        }

        private void tbMouseS_ValueChanged(object sender, EventArgs e)
        {
            decimal value = Convert.ToDecimal(this.tbMouseS.Value) / Convert.ToDecimal(this.tbMouseS.Maximum);

            if (this.nudMouseS.Minimum > value)
            {
                value = this.nudMouseS.Minimum;
            }
            else if (this.nudMouseS.Maximum < value)
            {
                value = this.nudMouseS.Maximum;
            }

            this.nudMouseS.Value = value;
        }

        private void nudMouseR_ValueChanged(object sender, EventArgs e)
        {
            decimal valueD = this.nudMouseR.Value;
            int valueI = Convert.ToInt32(valueD * Convert.ToDecimal(this.tbMouseR.Maximum));

            if (this.tbMouseR.Minimum > valueI)
            {
                valueI = this.tbMouseR.Minimum;
            }
            else if (this.tbMouseR.Maximum < valueI)
            {
                valueI = this.tbMouseR.Maximum;
            }

            this.tbMouseR.Value = valueI;
            this.manager.MouseSensitivity.Rotation = (float)Convert.ToDouble(valueD);
        }

        private void tbMouseR_ValueChanged(object sender, EventArgs e)
        {
            decimal value = Convert.ToDecimal(this.tbMouseR.Value) / Convert.ToDecimal(this.tbMouseR.Maximum);

            if (this.nudMouseR.Minimum > value)
            {
                value = this.nudMouseR.Minimum;
            }
            else if (this.nudMouseR.Maximum < value)
            {
                value = this.nudMouseR.Maximum;
            }

            this.nudMouseR.Value = value;
        }

        private void nudMouseT_ValueChanged(object sender, EventArgs e)
        {
            decimal valueD = this.nudMouseT.Value;
            int valueI = Convert.ToInt32(valueD * Convert.ToDecimal(this.tbMouseT.Maximum));

            if (this.tbMouseT.Minimum > valueI)
            {
                valueI = this.tbMouseT.Minimum;
            }
            else if (this.tbMouseT.Maximum < valueI)
            {
                valueI = this.tbMouseT.Maximum;
            }

            this.tbMouseT.Value = valueI;
            this.manager.MouseSensitivity.Translation = (float)Convert.ToDouble(valueD);
        }

        private void tbMouseT_ValueChanged(object sender, EventArgs e)
        {
            decimal value = Convert.ToDecimal(this.tbMouseT.Value) / Convert.ToDecimal(this.tbMouseT.Maximum);

            if (this.nudMouseT.Minimum > value)
            {
                value = this.nudMouseT.Minimum;
            }
            else if (this.nudMouseT.Maximum < value)
            {
                value = this.nudMouseT.Maximum;
            }

            this.nudMouseT.Value = value;
        }

        #endregion

    }
}
