﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            MainForm mainForm = null;
            Mix.Tool.Engine engine = null;

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            mainForm = new MainForm();
            engine = new Mix.Tool.Engine(60);

            Mix.Tool.Logger.Handle = mainForm.Handle;
            mainForm.Initialize(engine.GraphicsManager, engine.DynamicsWorld);

            Application.DoEvents();

            mainForm.Show();

            while (mainForm.Created)
            {
                Application.DoEvents();

                engine.Update();
                mainForm.Poll();
            }

            engine.Dispose();
        }
    }
}
