﻿using System;
using System.Collections.Generic;

namespace Mix.Tool.ModelEditor.Project
{
    /// <summary>
    /// モデルフォーマット列挙定数
    /// </summary>
    public enum ModelFormats
    {
        /// <summary>
        /// アクター
        /// </summary>
        Actor,

        /// <summary>
        /// 地形
        /// </summary>
        Terrain,
    }

    /// <summary>
    /// モデルトランスフォームクラス
    /// </summary>
    public class ModelTransform
    {
        private float scaling = 1.0f;
        private Mix.Tool.Math.Vector rotation = new Mix.Tool.Math.Vector(0.0f, 0.0f, 0.0f, 1.0f);
        private Mix.Tool.Math.Vector translation = new Mix.Tool.Math.Vector(0.0f, 0.0f, 0.0f, 1.0f);

        /// <summary>
        /// コンストラクタ
        /// </summary>
        internal ModelTransform()
        {
        }

        /// <summary>
        /// スケーリングの取得、または設定
        /// </summary>
        public float Scaling
        {
            get { return this.scaling; }
            set { this.scaling = value; }
        }

        /// <summary>
        /// ローテーションの取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector Rotation
        {
            get { return this.rotation; }
            set { this.rotation = value; }
        }

        /// <summary>
        /// トランスレーションの取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector Translation
        {
            get { return this.translation; }
            set { this.translation = value; }
        }
    };

    /// <summary>
    /// モデルスムージングクラス
    /// </summary>
    public class ModelSmooting
    {
        public bool enabled = false;
        public float angle = 45.0f;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        internal ModelSmooting()
        {
        }

        /// <summary>
        /// スムージングの有効にするかどうかの取得、または設定
        /// </summary>
        public bool Enabled
        {
            get { return this.enabled; }
            set { this.enabled = value; }
        }

        /// <summary>
        /// スムージング角度(DEG)の取得、または設定
        /// </summary>
        public float Angle
        {
            get { return this.angle; }
            set { this.angle = value; }
        }
    };

    /// <summary>
    /// モデルクラス
    /// </summary>
    public class Config
    {
        #region Private Member

        private string inputFilePath = "";
        private string outputFilePath = "";
        private Mix.Tool.Graphics.ModelImportOption opt = Mix.Tool.Graphics.ModelImportOption.Default;
        private ModelTransform transformProp = new ModelTransform();
        private ModelSmooting smootingProp = new ModelSmooting();
        private ModelFormats format = ModelFormats.Actor;
        private Mix.Tool.Math.Vector mmCellSize = new Mix.Tool.Math.Vector(100.0f, 100.0f, 100.0f);
        private string mmInputCollFilePath = "";
        private Mix.Tool.Graphics.ObjectModel.TimeModes omTimeMode = Mix.Tool.Graphics.ObjectModel.TimeModes.Frames60;

        #endregion

        #region Public Method

        /// <summary>
        /// 入力ファイルパスの取得、または設定
        /// </summary>
        public string InputFilePath
        {
            get { return this.inputFilePath; }
            set { this.inputFilePath = value; }
        }

        /// <summary>
        /// 出力ファイルパスの取得、または設定
        /// </summary>
        public string OutputFilePath
        {
            get { return this.outputFilePath; }
            set { this.outputFilePath = value; }
        }

        /// <summary>
        /// オプションの取得または設定
        /// </summary>
        public Mix.Tool.Graphics.ModelImportOption Option
        {
            get { return this.opt; }
            set { this.opt = value; }
        }

        /// <summary>
        /// トランスフォームの取得、または設定
        /// </summary>
        public ModelTransform Transform
        {
            get { return this.transformProp; }
        }

        /// <summary>
        /// スムージングの取得、または設定
        /// </summary>
        public ModelSmooting Smooting
        {
            get { return this.smootingProp; }
        }

        /// <summary>
        /// フォーマットの取得、または設定
        /// </summary>
        public ModelFormats Format
        {
            get { return this.format; }
            set { this.format = value; }
        }

        /// <summary>
        /// セルサイズ(マップモデル)の取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector MM_CellSize
        {
            get { return this.mmCellSize; }
            set { this.mmCellSize = value; }
        }

        /// <summary>
        /// コリジョンの入力ファイルパス
        /// </summary>
        public string MM_InputCollisionFilePath
        {
            get { return this.mmInputCollFilePath; }
            set { this.mmInputCollFilePath = (value != null) ? value : ""; }
        }

        /// <summary>
        /// タイムモード(オブジェクトモデル)の取得、または設定
        /// </summary>
        public Mix.Tool.Graphics.ObjectModel.TimeModes OM_TimeMode
        {
            get { return this.omTimeMode; }
            set { this.omTimeMode = value; }
        }

        #endregion
    }
}
