﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace Mix.Tool.ModelEditor.Project
{
    /// <summary>
    /// ログクラス
    /// </summary>
    public class Log
    {
        /// <summary>
        /// ログテキスト変更イベントデータクラス
        /// </summary>
        public class TextChangedEventArgs : System.EventArgs
        {
            private string message = "";

            internal TextChangedEventArgs(string _message)
            {
                this.message = _message;
            }

            /// <summary>
            /// メッセージを取得
            /// </summary>
            public string Message
            {
                get { return this.message; }
            }
        }

        /// <summary>
        /// ログテキスト変更イベントハンドラークラス
        /// </summary>
        /// <param name="e"></param>
        public delegate void TextChangedEventHandler(TextChangedEventArgs e);

        private string text;

        /// <summary>
        /// テキスト変更イベント
        /// </summary>
        public event TextChangedEventHandler TextChanged = null;

        /// <summary>
        /// テキストを取得
        /// </summary>
        public string Text
        {
            get { return this.text; }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Log()
        {
            Mix.Tool.Logger.ProcClear = this.Logger_ProcClear;
            Mix.Tool.Logger.ProcPrint = this.Logger_ProcPrint;
        }

        /// <summary>
        /// テキストを保存
        /// </summary>
        /// <param name="filePath">ファイルパス</param>
        internal void Save(string filePath)
        {
            try
            {
                StreamWriter output = new StreamWriter(filePath);

                output.Write(this.text);
                output.Close();
            }
            catch
            {
                throw;
            }
        }

        /// <summary>
        /// テキストをクリア
        /// </summary>
        public void Clear()
        {
            this.text = "";
        }

        private void InvokeTextChanged(string mes)
        {
            if (this.TextChanged != null)
            {
                this.TextChanged.Invoke(new TextChangedEventArgs(mes));
            }
        }

        private void Logger_ProcClear()
        {
            this.text = "";

            this.InvokeTextChanged("");
        }

        private void Logger_ProcPrint(Mix.Tool.Logger.Type type, string mes)
        {
            string temp = "";

            switch (type)
            {
                case Logger.Type.Info:
                    temp = "(INFO)\t: ";
                    break;
                case Logger.Type.Warning:
                    temp = "(WARNING)\t: ";
                    break;
                case Logger.Type.Error:
                    temp = "(ERROR)\t: ";
                    break;
            }

            temp += mes;

            this.InvokeTextChanged(temp);

            this.text += temp + "\r\n";
        }
    }
}
