﻿using System;
using System.Collections.Generic;

namespace Mix.Tool.ModelEditor.Project
{
    /// <summary>
    /// プレビュークラス
    /// </summary>
    public class Preview
    {
        /// <summary>
        /// エディットモード列挙定数
        /// </summary>
        public enum EidtModes
        {
            /// <summary>
            /// モデル
            /// </summary>
            Model,

            /// <summary>
            /// ライト
            /// </summary>
            Light,
        };

        /// <summary>
        /// ワールドモード列挙定数
        /// </summary>
        public enum WorldModes
        {
            /// <summary>
            /// 停止
            /// </summary>
            Stop,

            /// <summary>
            /// スタンド
            /// </summary>
            Stand,

            /// <summary>
            /// ラグドール
            /// </summary>
            Ragdoll,
        };

        private EidtModes editMode = EidtModes.Model;
        private WorldModes worldMode = WorldModes.Stop;
        private Mix.Tool.Graphics.Camera camera = null;
        private Mix.Tool.Graphics.Camera.FillModes fillMode = Mix.Tool.Graphics.Camera.FillModes.Solid;
        private Mix.Tool.Graphics.Camera.DrawTypes display = Mix.Tool.Graphics.Camera.DrawTypes.Default;
        private Mix.Tool.Math.Vector localPos = new Mix.Tool.Math.Vector(0.0f, 0.0f, -10.0f, 1.0f);
        private Mix.Tool.Math.Vector target = new Mix.Tool.Math.Vector();
        private Mix.Tool.Math.Vector pose = new Mix.Tool.Math.Vector(0.0f, 0.0f, 0.0f, 1.0f);

        /// <summary>
        /// エディットモードの取得、または設定
        /// </summary>
        public EidtModes EditMode
        {
            get { return this.editMode; }
            set { this.editMode = value; }
        }

        /// <summary>
        /// ワールドモードの取得、または設定
        /// </summary>
        public WorldModes WorldMode
        {
            get { return this.worldMode; }
            set { this.worldMode = value; }
        }

        /// <summary>
        /// フィルモードの取得、または設定
        /// </summary>
        public Mix.Tool.Graphics.Camera.FillModes FillMode
        {
            get { return this.fillMode; }
            set { this.fillMode = value; }
        }

        /// <summary>
        /// 表示の取得、または設定
        /// </summary>
        public Mix.Tool.Graphics.Camera.DrawTypes Display
        {
            get { return this.display; }
            set { this.display = value; }
        }

        /// <summary>
        /// ローカル位置の取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector LocalPosition
        {
            get { return new Mix.Tool.Math.Vector(this.localPos.X, this.localPos.Y, this.localPos.Z, this.localPos.W); }
            set
            {
                this.localPos.X = value.X;
                this.localPos.Y = value.Y;
                this.localPos.Z = value.Z;
                this.localPos.W = value.W;
            }
        }

        /// <summary>
        /// ターゲットの取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector Target
        {
            get { return new Mix.Tool.Math.Vector(this.target.X, this.target.Y, this.target.Z, this.target.W); }
            set
            {
                this.target.X = value.X;
                this.target.Y = value.Y;
                this.target.Z = value.Z;
                this.target.W = value.W;
            }
        }

        /// <summary>
        /// 姿勢(クォータニオン)の取得、または設定
        /// </summary>
        public Mix.Tool.Math.Vector Pose
        {
            get { return new Mix.Tool.Math.Vector(this.pose.X, this.pose.Y, this.pose.Z, this.pose.W); }
            set
            {
                this.pose.X = value.X;
                this.pose.Y = value.Y;
                this.pose.Z = value.Z;
                this.pose.W = value.W;
            }
        }

        /// <summary>
        /// カメラの取得、または設定
        /// </summary>
        public Mix.Tool.Graphics.Camera Camera
        {
            get { return this.camera; }
            set
            {
                this.camera = value;

                if (this.camera != null)
                {
                    this.camera.FillMode = this.fillMode;
                    this.camera.DrawType = this.display;
                    this.camera.Initialize(this.localPos, this.target, this.pose);
                }
            }
        }

        /// <summary>
        /// 設定されているソースの情報を更新します
        /// </summary>
        public void Flush()
        {
            if (this.camera != null)
            {
                this.fillMode = this.camera.FillMode;
                this.display = this.camera.DrawType;
                this.localPos = this.camera.LocalPosition;
                this.target = this.camera.Target;
                this.pose = this.camera.Pose;
            }
        }
    }
}
