﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace Mix.Tool.ModelEditor.Utility
{
    public class ComboBoxItem<ValueType>
    {
        private const int MARGIN = 2;

        private string text;
        private ValueType type;
        private Image image = null;
        private StringFormat strFormat = new StringFormat();

        public string Text
        {
            get { return this.text; }
            set { this.text = value; }
        }

        public ValueType Value
        {
            get { return this.type; }
            set { this.type = value; }
        }

        public Image Image
        {
            get { return this.image; }
            set { this.image = value; }
        }

        public ComboBoxItem(string _text, ValueType _type)
        {
            this.text = _text;
            this.type = _type;
            this.image = null;
        }

        public ComboBoxItem(string _text, ValueType _type, Image _image)
        {
            this.text = _text;
            this.type = _type;
            this.image = _image;

            this.strFormat.Alignment = StringAlignment.Near;
            this.strFormat.LineAlignment = StringAlignment.Center;
        }

        public void Draw(DrawItemEventArgs e)
        {
            Rectangle textBounds;

            e.DrawBackground();

            if (this.image != null)
            {
                int x = e.Bounds.X + MARGIN;
                int y = e.Bounds.Y + (e.Bounds.Height - this.Image.Height) / 2;

                e.Graphics.DrawImage(this.image, new PointF(x, y));

                textBounds = new Rectangle();
                textBounds.X = x + this.image.Width + MARGIN;
                textBounds.Y = e.Bounds.Y;
                textBounds.Width = e.Bounds.Width - textBounds.X - MARGIN;
                textBounds.Height = e.Bounds.Height;
            }
            else
            {
                textBounds = e.Bounds;
            }

            if (this.text.Length > 0)
            {
                Brush textBrush;

                if ((e.State & DrawItemState.Selected) == DrawItemState.Selected)
                {
                    textBrush = System.Drawing.SystemBrushes.HighlightText;
                }
                else
                {
                    textBrush = System.Drawing.SystemBrushes.ControlText;
                }

                e.Graphics.DrawString(this.text, e.Font, textBrush, textBounds, this.strFormat);
            }
        }
    };
}
