#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Button.h"
#include "Utility/UI/ComboBox.h"

class Room;

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 150,
		DLG_HEIGHT		= 120,

		ITEM_X			= 0,
		ITEM_WIDTH		= 128,
		ITEM_HEIGHT		= 20,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_LIST_CB		= 0,
		CTRL_EXPLOSION_B	= 1,
		CTRL_RESET_B		= 2,
	};

	enum BUILDING_TYPE
	{
		BUILDING_BILLIARDS	= 0,
		BUILDING_PYRAMID	= 1,
		BUILDING_BABEL		= 2,
	};

private:
	Room* m_pRoom;

	Utility::UI::ComboBox m_ListCB;
	Utility::UI::Button m_ResetB;
	Utility::UI::Button m_ExplosionB;

public:
	HUD( void );
	~HUD( void );

public:
	void Initialize( Room* pRoom, const Mix::Point& screenSize );
	void Build( void );

protected:
	virtual void OnDispose( void );
	virtual void OnButton_Click( Utility::UI::Button* pButton );
	virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox );

private:
	void BuildBilliards( void );
	void BuildPyramid( void );
	void BuildBabel( void );
};
