#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/Graphics.h"
#include "Utility/Common.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_GRAPHICS;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"Graphics\\Canvas" );
	engineConfig.pCaption = L"Graphics - Canvas";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();

		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::ITexture* pImage = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, MIX_DEBUGNAME ) == True )
		{
			Mix::Graphics::Utility::IFont* pFont = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont ) == True )
			{
				pCanvasRenderer->SetFont( pFont );
			}

			MIX_RELEASE( pFont );
		}

		pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\Tree.png", &pImage );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pEngine->ResetFPS();

		while( pEngine->Update() == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////

			static const Mix::Vector2 polygonPos( 800.0f, 128.0f );

			static const Mix::Vector2 polygonPoints[6] =
			{
				Mix::Vector2(   0.0f, -64.0f ),

				Mix::Vector2( +64.0f, -32.0f ),
				Mix::Vector2( +64.0f, +32.0f ),

				Mix::Vector2(   0.0f, +64.0f ),

				Mix::Vector2( -64.0f, +32.0f ),
				Mix::Vector2( -64.0f, -32.0f ),
			};

			static const UInt16 polygonPointNum = sizeof( polygonPoints ) / sizeof( Mix::Vector2 );

			////////////////////////////////////////////////////////////////////////////////////////////////////

			Mix::Vector2 starPoints[] =
			{
				Mix::Vector2( -96.0f, -32.0f ), //0
				Mix::Vector2( -32.0f, -32.0f ), //1

				Mix::Vector2( -32.0f, -32.0f ),
				Mix::Vector2(   0.0f, -96.0f ), //2

				Mix::Vector2(   0.0f, -96.0f ),
				Mix::Vector2( +32.0f, -32.0f ), //3

				Mix::Vector2( +32.0f, -32.0f ),
				Mix::Vector2( +96.0f, -32.0f ), //4

				Mix::Vector2( +96.0f, -32.0f ),
				Mix::Vector2( +40.0f, +16.0f ), //5

				Mix::Vector2( +40.0f, +16.0f ),
				Mix::Vector2( +64.0f, +96.0f ), //6

				Mix::Vector2( +64.0f, +96.0f ),
				Mix::Vector2(   0.0f, +48.0f ), //7

				Mix::Vector2(   0.0f, +48.0f ),
				Mix::Vector2( -64.0f, +96.0f ), //8

				Mix::Vector2( -64.0f, +96.0f ),
				Mix::Vector2( -40.0f, +16.0f ), //9

				Mix::Vector2( -40.0f, +16.0f ),
				Mix::Vector2( -96.0f, -32.0f ), //0
			};

			static const UInt32 starPointNum = sizeof( starPoints ) / sizeof( Mix::Vector2 );
			static const Float32 starRot = 1.0f;
			static const Mix::Vector2 starPos( 256.0f, 448.0f );
			static Float32 starAngle = 0.0f;

			////////////////////////////////////////////////////////////////////////////////////////////////////

			static const Mix::Vector2 textPos( 64.0f, 144.0f );
			static const Mix::Vector2 textRange( 512.0f, 64.0f );

			////////////////////////////////////////////////////////////////////////////////////////////////////

			Mix::String tempStr;
			Mix::Matrix3x3 tempMat;
			Mix::Matrix3x3 mat;

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// C[W̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddImage( pImage, Mix::RectangleF( 448.0f, 192.0f, 512.0f, 512.0f ), Mix::RectangleF( 0.0f, 0.0f, 512.0f, 512.0f ) );

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// `̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			/*
				FillRectangle - `̕`( DrawText ̔wi )
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 0.1f, 0.1f, 0.3f, 1.0f ) );
			pCanvasRenderer->AddFillRectangle( Mix::RectangleF( textPos.x + 1.0f, textPos.y + 1.0f, textRange.x - 2.0f, textRange.y - 2.0f ) );

			/*
				DrawRectangle - `̕`( DrawText ̘g )
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 0.0f, 0.0f, 1.0f ) );
			pCanvasRenderer->AddRectangle( Mix::RectangleF( textPos.x, textPos.y, textRange.x, textRange.y ) );

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// |S̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pCanvasRenderer->PushMatrix();

			mat.SetTranslation( polygonPos );
			pCanvasRenderer->SetMatrix( mat );

			/*
				FillPolygon
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 0.8f, 0.8f, 1.0f ) );
			pCanvasRenderer->AddFillPolygon( polygonPoints, polygonPointNum );

			/*
				DrawPolygon
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 0.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddPolygon( polygonPoints, polygonPointNum );

			pCanvasRenderer->PopMatrix();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// C̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			/*
				DrawLine
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 0.5f, 0.5f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddLine( Mix::Vector2( 64.0f, 704.0f ), Mix::Vector2( 960.0f, 704.0f ) );

			/*
				DrawLines
			*/

			mat = Mix::Matrix3x3::Identity();
			mat.SetRotation( starAngle );
			tempMat.SetTranslation( starPos );
			mat *= tempMat;

			starAngle += pEngine->GetDT() * starRot;
			if( starAngle >= MIX_2PI )
			{
				starAngle -= MIX_2PI;
			}

			pCanvasRenderer->PushMatrix();
			pCanvasRenderer->SetMatrix( mat );
			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 0.3f, 1.0f ) );
			pCanvasRenderer->AddLines( starPoints, starPointNum );
			pCanvasRenderer->PopMatrix();

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// ʏ̕̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			/*
				DrawString
			*/

			tempStr.Sprintf( L"ʏ̕̕`B\nsł܂B" );

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddString( 64.0f, 64.0f, tempStr.GetConstPtr() );

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// eLXgC^[tF[Xgp̕̕`
			////////////////////////////////////////////////////////////////////////////////////////////////////

			/*
				DrawText
			*/

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddString( Mix::RectangleF( textPos.x, textPos.y, 512.0f, 64.0f ),
								L"eLXgC^[tF[Xg̕`B\nZ^OȂǂ̃IvVw肷邱Ƃł܂B",
								Mix::Graphics::Utility::SF_HCENTER | Mix::Graphics::Utility::SF_VCENTER );

			////////////////////////////////////////////////////////////////////////////////////////////////////

			pCanvasRenderer->Update();

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );
			pGraphicsDev->Clear( True, False, Mix::Vector4( 0.1f, 0.1f, 0.1f, 1.0f ) );

			if( pGraphicsDev->Begin() == True )
			{
				pCanvasRenderer->Draw();

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		MIX_RELEASE( pImage );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pGraphicsDev );

		Mix::Finalize();
	}

	return 0;
}
