#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/Graphics.h"
#include "Mix/HID.h"
#include "Utility/Common.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

const wchar_t* KEY_TEXT_TABLE[Mix::HID::KEY_MAX] =
{
	L"F1",
	L"F2",
	L"F3",
	L"F4",
	L"F5",
	L"F6",
	L"F7",
	L"F8",
	L"F9",
	L"F10",
	L"F11",
	L"F12",
	L"0",
	L"1",
	L"2",
	L"3",
	L"4",
	L"5",
	L"6",
	L"7",
	L"8",
	L"9",
	L"NUMPAD0",
	L"NUMPAD1",
	L"NUMPAD2",
	L"NUMPAD3",
	L"NUMPAD4",
	L"NUMPAD5",
	L"NUMPAD6",
	L"NUMPAD7",
	L"NUMPAD8",
	L"NUMPAD9",
	L"A",
	L"B",
	L"C",
	L"D",
	L"E",
	L"F",
	L"G",
	L"H",
	L"I",
	L"J",
	L"K",
	L"L",
	L"M",
	L"N",
	L"O",
	L"P",
	L"Q",
	L"R",
	L"S",
	L"T",
	L"U",
	L"V",
	L"W",
	L"X",
	L"Y",
	L"Z",
	L"UP",
	L"DOWN",
	L"LEFT",
	L"RIGHT",
	L"ESCAPE",
	L"TAB",
	L"BACKSPACE",
	L"DELETE",
	L"SPACE",
	L"RETURN",
	L"SHIFT",
	L"LSHIFT",
	L"RSHIFT",
	L"CTRL",
	L"LCTRL",
	L"RCTRL",
	L"ALT",
	L"LALT",
	L"RALT",
};

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_KEYBOARD | Mix::EC_GRAPHICS;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"HID\\Keyboard" );
	engineConfig.pCaption = L"HID - Keyboard";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pHIDMgr = Mix::HID::GetManagerPtr();
		Mix::HID::IKeyboard* pKeyboard = NULL;
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;
		Mix::Graphics::Utility::IFont* pFont = NULL;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pHIDMgr->GetKeyboard( &pKeyboard );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, MIX_DEBUGNAME ) == True )
		{
			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont ) == True )
			{
				pCanvasRenderer->SetFont( pFont );
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		Mix::Vector2 pos( 512.0f - 8.0f, 384.0f - 8.0f );

		while( pEngine->Update() == True )
		{
			Mix::String keyStr;

			////////////////////////////////////////////////////////////////////////////////////////////////////

			for( UInt32 i = 1; i < Mix::HID::KEY_MAX; i++ )
			{
				if( pKeyboard->GetKeyState( static_cast<Mix::HID::KEY>( i ) ) & Mix::HID::DOWN )
				{
					keyStr += KEY_TEXT_TABLE[i - 1];
					if( i < ( Mix::HID::KEY_MAX - 1 ) )
					{
						keyStr += L" ";
					}
				}
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////

			pCanvasRenderer->SetColor( Mix::Vector4( 0.6f, 0.6f, 0.6f, 1.0f ) );
			pCanvasRenderer->AddLine( Mix::Vector2( 16.0f, 384.0f + 16.0f + 2.0f ), Mix::Vector2( 1024.0f - 16.0f, 384.0f + 16.0f + 2.0f ) );

			if( keyStr.GetNum() > 0 )
			{
				Mix::Point textSize = Mix::Graphics::Utility::MeasureString( pFont, keyStr.GetConstPtr() );

				pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
				pCanvasRenderer->AddString( static_cast<Float32>( SCREEN_WIDTH - textSize.x ) * 0.5f, 384.0f, keyStr.GetConstPtr() );
			}

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddString( 16.0f, 16.0f, L"L[ĂB\nɕ̃L[Ƃł܂B" );

			pCanvasRenderer->Update();

			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );
			pGraphicsDev->Clear( True, False, Mix::Vector4( 0.1f, 0.1f, 0.1f, 1.0f ) );

			if( pGraphicsDev->Begin() == True )
			{
				pCanvasRenderer->Draw();

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		MIX_RELEASE( pFont );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pKeyboard );

		Mix::Finalize();
	}

	return 0;
}
