#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/Graphics.h"
#include "Mix/HID.h"
#include "Utility/Common.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_MOUSE | Mix::EC_GRAPHICS;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"HID\\Mouse" );
	engineConfig.pCaption = L"HID - Mouse";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pHIDMgr = Mix::HID::GetManagerPtr();
		Mix::HID::IMouse* pMouse = NULL;
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::ITexture* pMousePointerTex = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pHIDMgr->GetMouse( &pMouse );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\MousePointer.png", &pMousePointerTex );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, MIX_DEBUGNAME ) == True )
		{
			Mix::Graphics::Utility::IFont* pFont = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont ) == True )
			{
				pCanvasRenderer->SetFont( pFont );
			}

			MIX_RELEASE( pFont );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		Float32 mousePointerScale = 1.0f;
		UInt32 mouseLeftClickCount = 0;
		UInt32 mouseMiddleClickCount = 0;
		UInt32 mouseRightClickCount = 0;

		while( pEngine->Update() == True )
		{
			const Mix::Point& mousePos = pMouse->GetPos();
			Mix::Vector2 mousePosF = mousePos;
			Int32 mouseWheel = pMouse->GetWheelDelta();
			Mix::Matrix3x3 mat;
			Mix::String tempStr;

			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pMouse->GetButtonState( 0 ) & Mix::HID::RELEASED )
			{
				mouseLeftClickCount++;
			}

			if( pMouse->GetButtonState( 1 ) & Mix::HID::RELEASED )
			{
				mouseRightClickCount++;
			}

			if( pMouse->GetButtonState( 2 ) & Mix::HID::RELEASED )
			{
				mouseMiddleClickCount++;
			}

			if( mouseWheel < 0 )
			{
				mousePointerScale += 1.0f;
			}
			else if( mouseWheel > 0 )
			{
				mousePointerScale -= 1.0f;
			}

			mousePointerScale = MIX_CLAMP( mousePointerScale, 1.0f, 10.0f );

			////////////////////////////////////////////////////////////////////////////////////////////////////

			mat.SetScaling( mousePointerScale );
			mat.m20 = mousePosF.x;
			mat.m21 = mousePosF.y;
			mat.m22 = 1.0f;

			pCanvasRenderer->PushMatrix();
			pCanvasRenderer->SetMatrix( mat );
			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddImage( pMousePointerTex, 0, 0, 20, 20, 0, 0 );
			pCanvasRenderer->PopMatrix();

			tempStr.Sprintf( L"Position ( %d, %d )\n\nLeftClick   %d\nRightClick  %d\nMiddleClick %d",
				mousePos.x, mousePos.y,
				mouseLeftClickCount,
				mouseRightClickCount,
				mouseMiddleClickCount );

			pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
			pCanvasRenderer->AddString( 16, 16, tempStr.GetConstPtr() );

			pCanvasRenderer->Update();

			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );
			pGraphicsDev->Clear( True, False, Mix::Vector4( 0.1f, 0.1f, 0.1f, 1.0f ) );

			if( pGraphicsDev->Begin() == True )
			{
				pCanvasRenderer->Draw();

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pMousePointerTex );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pMouse );

		Mix::Finalize();
	}

	return 0;
}
