#pragma once

#include "Utility/UI.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 160,
		DLG_HEIGHT		= 248,

		ITEM_X			= 0,
		ITEM_WIDTH		= 144,
		ITEM_HEIGHT		= 20,

		ITEM_X1			= ITEM_X,
		ITEM_WIDTH1		= ITEM_WIDTH / 8 * 5 - 1,
		ITEM_HEIGHT1	= ITEM_HEIGHT,

		ITEM_X2			= ITEM_X1 + ITEM_WIDTH1 + 2,
		ITEM_WIDTH2		= ITEM_WIDTH / 8 * 3 - 1,
		ITEM_HEIGHT2	= ITEM_HEIGHT,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB			= 0,

		CTRL_SMOOTH_L			= 1,
		CTRL_SMPL_CB			= 2,
		CTRL_SMOOTH_CB			= 3,
		CTRL_SMOOTH_SI			= 4,

		CTRL_OCCL_L				= 5,
		CTRL_RADIUS_SF			= 6,
		CTRL_THRESHOLD_SF		= 7,
		CTRL_DISTANCE_SF		= 8,
		CTRL_INTENSITY_SF		= 9,
	};

private:
	Mix::Scene::IRenderer* m_pSceneRenderer;
	Mix::Scene::ICamera* m_pCamera;

	Utility::UI::CheckBox m_EnabledCB;

	Utility::UI::Label m_SmoothL;
	Utility::UI::ComboBox m_SmplCB;
	Utility::UI::ComboBox m_SmoothCB;
	Utility::UI::SliderI m_SmoothSI;

	Utility::UI::Label m_OcclL;
	Utility::UI::SliderF m_RadiusF;
	Utility::UI::SliderF m_ThresholdF;
	Utility::UI::SliderF m_DistanceF;
	Utility::UI::SliderF m_IntensityF;

	Mix::Scene::BLUR m_SmoothTable[Mix::Scene::BLUR::TYPE_MAX];

	static const Int32 SMOOTH_RANGE_TABLE[Mix::Scene::BLUR::TYPE_MAX][2];

public:
	HUD( void );
	virtual ~HUD( void );

	void Open( Utility::UI::Manager* pManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

	static Int32 GetSmoothValue( const Mix::Scene::BLUR& blur );
	static void SetSmoothValue( Mix::Scene::BLUR& blur, Int32 value );

public:
	virtual void OnOpen( void );
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox );
};
