#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/HID.h"
#include "Mix/Graphics.h"
#include "Mix/Scene.h"

#include "Utility/Common.h"
#include "Utility/ViewCameraHelper.h"

#include "hud.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

#define AO_TEX_WIDTH 224
#define AO_TEX_HEIGHT 224

#define ROTATE_LIGHT_COIFFE 0.01f

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_KEYBOARD | Mix::EC_MOUSE | Mix::EC_GRAPHICS | Mix::EC_SCENE;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"Scene\\AmbientOcclusion" );
	engineConfig.pCaption = L"Scene - AmbientOcclusion";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pInputMgr = Mix::HID::GetManagerPtr();
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Scene::IManager* pSceneMgr = Mix::Scene::GetManagerPtr();

		Mix::HID::IMouse* pMouse = NULL;
		Mix::HID::IKeyboard* pKeyboard = NULL;
		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;
		Mix::Graphics::Utility::IFont* pFont_12_200 = NULL;
		Mix::Graphics::Utility::IFont* pFont_16_400 = NULL;
		Mix::Scene::IEffectPackage* pSceneEffectPackage = NULL;
		Mix::Scene::IRenderer* pSceneRenderer = NULL;
		Mix::Scene::IViewCamera* pCamera = NULL;
		Mix::Scene::IDirectionalLight* pDirLight = NULL;

		Utility::ViewCameraHelper viewCamHelper;
		Utility::UI::Manager uiManager;
		HUD m_HUD;
		Mix::StringW tempStr;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pInputMgr->GetMouse( &pMouse );
		pInputMgr->GetKeyboard( &pKeyboard );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, L"Sample" ) == True )
		{
			pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_12_200.fnt", &pFont_12_200 );

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont_16_400 ) == True )
			{
				pCanvasRenderer->SetFont( pFont_16_400 );
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( pSceneMgr->CreateEffectPackage( L"Data\\", L"effects", &pSceneEffectPackage ) == True )
		{
			Mix::Scene::RENDERER_CONFIG config;

			config.caps = Mix::Scene::RCAP_AMBIENT_OCCLUSION;

			if( pSceneMgr->CreateRenderer( pSceneEffectPackage, config, &pSceneRenderer, L"Sample" ) == True )
			{
				Mix::Scene::CAMERA_CONFIG camConfig;
				Mix::Scene::IActorModel* pModel = NULL;

				camConfig.caps = Mix::Scene::RCAP_SHADOW_MAPPING | Mix::Scene::RCAP_AMBIENT_OCCLUSION;
				camConfig.targetSize.Set( SCREEN_WIDTH, SCREEN_HEIGHT );
				camConfig.smSmplRes = Mix::Scene::RSMPL_DEFAULT;
				camConfig.colorTexFormat = Mix::Graphics::FMT_R8G8B8A8;

				if( pSceneMgr->CreateViewCamera( camConfig, &pCamera ) == True )
				{
					Mix::Graphics::ITexture* pNoiseTex = NULL;

					pCamera->SetProjection( MIX_TO_RAD( 60.0f ), 0.1f, 1000.0f );

					if( pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\noise.png", &pNoiseTex ) == True )
					{
						pCamera->SetAmbientOcclusionTexture( pNoiseTex );
						MIX_RELEASE( pNoiseTex );
					}

					pSceneRenderer->AddCamera( pCamera );
				}

				if( pSceneMgr->CreateDirectionalLight( &pDirLight ) == True )
				{
					pDirLight->SetDirection( Mix::Vector3( +1.0f, -0.5f, +1.0f ).ToNormalize() );
					pSceneRenderer->SetDirectionalLight( pDirLight );
				}

				if( pSceneMgr->CreateActorModelFromFile( pSceneEffectPackage, L"Data\\Model\\suzanne.mam", &pModel ) == True )
				{
					pModel->Reset();
					pSceneRenderer->AddActorModel( pModel );
					MIX_RELEASE( pModel );
				}

#ifdef _DEBUG
				UInt32 debDrawFlags = pCamera->Debug_GetDrawFlags();
				Mix::Graphics::Utility::IPerspectiveRenderer* pDebLineArt = NULL;

				MIX_SETBIT( debDrawFlags, Mix::Scene::DDF_DIRLIGHT_SHAPE );
				pCamera->Debug_SetDrawFlags( debDrawFlags );

				if( pGraphicsMgr->CreatePerspectiveRenderer( &pDebLineArt, L"Sample" ) == True )
				{
					pSceneRenderer->Debug_SetPerspectiveRenderer( pDebLineArt );
				}

				MIX_RELEASE( pDebLineArt );
#endif //_DEBUG
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		viewCamHelper.Initialize(	pMouse,
									pKeyboard,
									Mix::Vector3( 0.2f, -0.2f, 0.0f ),
									Mix::Vector2( MIX_TO_RAD( 10.0f ), MIX_TO_RAD( -165.0f ) ),
									2.5f );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		uiManager.Initialize( pMouse, pCanvasRenderer, pFont_12_200 );

		m_HUD.Open( &uiManager, pSceneRenderer, pCamera );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pEngine->ResetFPS();

		while( pEngine->Update() == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// J̑
			////////////////////////////////////////////////////////////////////////////////////////////////////

			viewCamHelper.Update();

			if( pCamera != NULL )
			{
				pCamera->SetRotation( viewCamHelper.GetRotation() );
				pCamera->SetAt( viewCamHelper.GetAt() );
				pCamera->SetDistance( viewCamHelper.GetDistance() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// fBNViCg̑
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pMouse != NULL )
			{
				Mix::Vector2 mouseVel = pMouse->GetVelocity();
				Int32 mouseWheel = pMouse->GetWheelDelta();

				if( mouseVel.GetLengthSqr() > 0 )
				{
					if( ( pMouse->GetButtonState( 1 ) & Mix::HID::DOWN ) == Mix::HID::DOWN )
					{
						if( ( pCamera != NULL ) &&
							( pDirLight != NULL ) )
						{
							Mix::Matrix4x4 invCamRotMat = pCamera->GetRotationMatrix();
							Mix::Vector3 yAxis( 0.0f, 1.0f, 0.0f );
							Mix::Vector3 xAxis( 1.0f, 0.0f, 0.0f );

							Mix::Quaternion rot;

							yAxis = invCamRotMat * yAxis;
							xAxis = invCamRotMat * xAxis;

							rot.SetRotationAxis( yAxis, mouseVel.x * -ROTATE_LIGHT_COIFFE );
							rot.RotationAxis( xAxis, mouseVel.y * ROTATE_LIGHT_COIFFE );
							rot.Normalize();

							pDirLight->SetDirection( Mix::Matrix4x4( rot ).TransformSR( pDirLight->GetDirection() ) );
						}
					}
				}
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// LoX̑
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCanvasRenderer != NULL )
			{
				Mix::Vector2 screenSize = pGraphicsDev->GetScreenSize();
				Mix::Vector2 txtSize;

				pCanvasRenderer->SetColor(		Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );

				tempStr.Sprintf(	L"FPS   [%f]\n"
									L"STps  [%f]\n"
									L"IFCps [%d/%d]"	,	pEngine->GetFPS(),
														pEngine->GetSleepTimePerSec(),
														pEngine->GetInsomniaFrameCountPerSec(), pEngine->GetInsomniaFrameMax() );

				pCanvasRenderer->AddString( 16.0f, 16.0f, tempStr.GetConstPtr() );

				tempStr.Sprintf(	L"Controls :\n"
									L"  Rotate camera  : Mouse middle button\n"
									L"  Move camera    : Mouse middle button + Shift key\n"
									L"  Distant camera : Mouse middle button + Ctrl key or Mouse wheel\n"
									L"  Rotate light   : Mouse right button" );

				txtSize = Mix::Graphics::Utility::MeasureString( pFont_16_400, tempStr.GetConstPtr() );
				pCanvasRenderer->AddString( 16.0f, screenSize.y - txtSize.y - 16.0f, tempStr.GetConstPtr() );

#ifdef _DEBUG
				Utility::Debug_DrawCameraImage( pCamera, Mix::Scene::DIT_AMBIENT_OCCLUSION, 0, pCanvasRenderer, Mix::Rectangle( SCREEN_WIDTH - AO_TEX_WIDTH - 16, 16, AO_TEX_WIDTH, AO_TEX_HEIGHT ), Mix::Vector4( 0.5f, 0.5f, 0.5f, 1.0f ) );
#endif //_DEBUG

				uiManager.Update();

				Utility::DrawMouseCursor( pCanvasRenderer, pMouse->GetPos() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCamera != NULL )
			{
				pCamera->Update();
			}

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Update( pEngine->GetDT() );
			}

			if( pCanvasRenderer != NULL )
			{
				pCanvasRenderer->Update();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tbV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Refresh();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// `
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );
			pGraphicsDev->Clear( True, False, Mix::Vector4( 0.1f, 0.1f, 0.1f, 1.0f ) );

			if( pGraphicsDev->Begin() == True )
			{
				if( pCamera != NULL )
				{
					pCamera->Draw();
				}

				if( pCanvasRenderer != NULL )
				{
					pCanvasRenderer->Draw();
				}

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		viewCamHelper.Dispose();
		uiManager.Dispose();

		MIX_RELEASE( pFont_12_200 );
		MIX_RELEASE( pFont_16_400 );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pDirLight );
		MIX_RELEASE( pCamera );
		MIX_RELEASE( pSceneRenderer );
		MIX_RELEASE( pSceneEffectPackage );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pKeyboard );
		MIX_RELEASE( pMouse );

		Mix::Finalize();
	}

	return 0;
}
