#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Label.h"
#include "Utility/UI/Slider.h"

class HUD : public Utility::UI::Dialog
{
private:
	static const Float32 SUN_RANGE;
	static const Float32 NIGHT_START;

	enum VALUE
	{
		DLG_WIDTH		= 214,
		DLG_HEIGHT		= 416,

		LABEL_X			= 0,
		LABEL_WIDTH		= 48,

		ITEM_X			= 48,
		ITEM_WIDTH		= 144,
		ITEM_HEIGHT		= 20,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_BASIS_L			= 0,
		CTRL_BASIS_RADIUS_SF	= 1,
		CTRL_BASIS_LAYER_SF		= 2,

		CTRL_SUN_L				= 3,
		CTRL_SUN_INTENSITY_SF	= 4,
		CTRL_SUN_TURBIDITY_SF	= 5,
		CTRL_SUN_POSITION_SF	= 6,

		CTRL_FOG_L				= 7,
		CTRL_FOG_START_SF		= 8,
		CTRL_FOG_DISTANCE_SF	= 9,

		CTRL_DETAIL_L			= 10,
		CTRL_DETAIL_HG_SF		= 11,
		CTRL_DETAIL_RAYLEIGH_SF	= 12,
		CTRL_DETAIL_MIE_SF		= 13,
		CTRL_DETAIL_LIN_SF		= 14,
		CTRL_DETAIL_FEX_R_SF	= 15,
		CTRL_DETAIL_FEX_G_SF	= 16,
		CTRL_DETAIL_FEX_B_SF	= 17,
		CTRL_DETAIL_FEX_A_SF	= 18,
	};

private:
	Mix::Scene::IRenderer* m_pRenderer;
	Mix::Scene::ISkyDome* m_pSkyDome;
	Mix::Scene::IAtmosphereScatter* m_pAtmosphereScatter;

	Utility::UI::Label m_BasisL;
	Utility::UI::SliderF m_BasisRadiusSF;
	Utility::UI::SliderF m_BasisLayerSF;

	Utility::UI::Label m_SunL;
	Utility::UI::SliderF m_SunIntensitySF;
	Utility::UI::SliderF m_SunTurbiditySF;
	Utility::UI::SliderF m_SunPositionSF;

	Utility::UI::Label m_FogL;
	Utility::UI::SliderF m_FogStartSF;
	Utility::UI::SliderF m_FogDistanceSF;

	Utility::UI::Label m_DetailL;
	Utility::UI::SliderF m_DetailHGSF;
	Utility::UI::SliderF m_DetailRayleighSF;
	Utility::UI::SliderF m_DetailMieSF;
	Utility::UI::SliderF m_DetailLinSF;
	Utility::UI::SliderF m_DetailFexRedSF;
	Utility::UI::SliderF m_DetailFexGreenSF;
	Utility::UI::SliderF m_DetailFexBlueSF;
	Utility::UI::SliderF m_DetailFexAlphaSF;

public:
	HUD( void );
	~HUD( void );

public:
	void Initialize(	Mix::Scene::IRenderer* pRenderer,
						Mix::Scene::ISkyDome* pSkyDome,
						Mix::Scene::IAtmosphereScatter* pAtmosphereScatter,
						const Mix::Point& screenSize );

protected:
	virtual void OnOpen( void );
	virtual void OnDispose( void );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
};
