#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/HID.h"
#include "Mix/Graphics.h"
#include "Mix/Scene.h"

#include "Utility/Common.h"
#include "Utility/ViewCameraHelper.h"
#include "Utility/UI/Manager.h"

#include "hud.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_KEYBOARD | Mix::EC_MOUSE | Mix::EC_GRAPHICS | Mix::EC_SCENE;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"Scene\\AtmosphereScattering" );
	engineConfig.pCaption = L"Scene - AtmosphereScattering";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pInputMgr = Mix::HID::GetManagerPtr();
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Scene::IManager* pSceneMgr = Mix::Scene::GetManagerPtr();

		Mix::HID::IMouse* pMouse = NULL;
		Mix::HID::IKeyboard* pKeyboard = NULL;
		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;
		Mix::Scene::IEffectPackage* pSceneEffectPackage = NULL;
		Mix::Scene::IRenderer* pSceneRenderer = NULL;
		Mix::Scene::IViewCamera* pCamera = NULL;
		Mix::Scene::IDirectionalLight* pDirLight = NULL;
		Mix::Scene::ISkyDome* pSkyDome = NULL;
		Mix::Scene::IAtmosphereScatter* pAtmosphereScatter = NULL;

		Utility::ViewCameraHelper viewCamHelper;
		Utility::UI::Manager uiManager;

		HUD hud;

		Mix::StringW tempStr;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pInputMgr->GetMouse( &pMouse );
		pInputMgr->GetKeyboard( &pKeyboard );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, L"Sample" ) == True )
		{
			Mix::Graphics::Utility::IFont* pFont_16_400 = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont_16_400 ) == True )
			{
				pCanvasRenderer->SetFont( pFont_16_400 );
			}

			MIX_RELEASE( pFont_16_400 );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( pSceneMgr->CreateEffectPackage( L"Data\\", L"effects", &pSceneEffectPackage ) == True )
		{
			Mix::Scene::RENDERER_CONFIG config;

			config.caps = Mix::Scene::RCAP_ATMOSPHERE;

			if( pSceneMgr->CreateRenderer( pSceneEffectPackage, config, &pSceneRenderer, L"Sample" ) == True )
			{
				Mix::Scene::CAMERA_CONFIG camConfig;
				Mix::Scene::IAtmosphereScatter::DAY_SETTINGS asDaySetting;
				Mix::Scene::IRenderer::FOG_SETTINGS fogSetting;
				Mix::Graphics::ITexture* pTex = NULL;
				Mix::Scene::ITerrainModel* pTerrainModel = NULL;

				camConfig.targetSize.Set( SCREEN_WIDTH, SCREEN_HEIGHT );
				camConfig.caps = 0;
				camConfig.colorTexFormat = Mix::Graphics::FMT_R8G8B8A8;
//				camConfig.colorTexFormat = Mix::Graphics::FMT_R16G16B16A16F;

				if( pSceneMgr->CreateViewCamera( camConfig, &pCamera ) == True )
				{
					pCamera->SetProjection( MIX_TO_RAD( 80.0f ), ( Float32 )SCREEN_WIDTH / ( Float32 )SCREEN_HEIGHT, 1.0f, 2000.0f );
					pCamera->SetFilmicType( Mix::Scene::ICamera::FI_HABLE );

					pSceneRenderer->AddCamera( pCamera );
				}

				if( pSceneMgr->CreateTerrainModelFromFile( pSceneEffectPackage, L"Data\\Model\\mountains.mtm", &pTerrainModel ) == True )
				{
					pSceneRenderer->AddTerrainModel( pTerrainModel );
				}

				if( pSceneMgr->CreateSkyDome(	1000.0f,
												150.0f,
												Mix::Scene::ISkyDome::QL_MIDDLE,
												&pSkyDome,
												MIX_DEBUGNAME ) == True )
				{
					pSkyDome->SetConstraintType( Mix::Scene::ISkyDome::CR_XYZ );

					if( pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\nightSky.dds", &pTex ) == True )
					{
						pSkyDome->SetBaseTexture( pTex );
						MIX_RELEASE( pTex );
					}

					pSkyDome->SetSunPosition( Mix::Vector3( 0.0f, 1.0f, 0.0f ) );

					if( pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\cloud0.dds", &pTex ) == True )
					{
						pSkyDome->SetCloudLayerTexture( 0, pTex );
						MIX_RELEASE( pTex );
					}

					if( pGraphicsDev->CreateTextureFromFile( L"Data\\Texture\\cloud1.dds", &pTex ) == True )
					{
						pSkyDome->SetCloudLayerTexture( 1, pTex );
						MIX_RELEASE( pTex );
					}

					pSkyDome->SetCloudEnabled( True );

					pSceneRenderer->SetSkyDome( pSkyDome );
				}

				if( pSceneMgr->CreateDirectionalLight( &pDirLight ) == True )
				{
					pSceneRenderer->SetDirectionalLight( pDirLight );
				}

				pSceneRenderer->GetAtmosphereScatter( &pAtmosphereScatter );

				asDaySetting = pAtmosphereScatter->GetDaySettings();
				asDaySetting.sunIntensity = 0.2f;
				asDaySetting.sunTurbidity = 1.9f;
				asDaySetting.henyeyGreenstein = 0.93f;
				pAtmosphereScatter->SetDaySettings( asDaySetting );

				fogSetting = pSceneRenderer->GetFogSettings();
				fogSetting.color = Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f );
				fogSetting.start = 100.0f;
				fogSetting.end = 1000.0f;
				pSceneRenderer->SetFogSettings( fogSetting );
				pSceneRenderer->SetFogEnabled( True );

				MIX_RELEASE( pTerrainModel );
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		viewCamHelper.Initialize(	pMouse,
									pKeyboard,
									Mix::Vector3( 0.0f, 100.0f, 0.0f ),
									Mix::Vector2( MIX_TO_RAD( 0.0f ), MIX_TO_RAD( 180.0f ) ),
									10.0f,
									0.5f,
									0.01f,
									1.0f,
									10.0f );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( ( pMouse != NULL ) &&
			( pCanvasRenderer != NULL ) &&
			( pAtmosphereScatter != NULL ) )
		{
			Mix::Graphics::Utility::IFont* pFont_12_200 = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_12_200.fnt", &pFont_12_200 ) == True )
			{
				uiManager.Initialize( pMouse, pCanvasRenderer, pFont_12_200 );

				hud.Initialize( pSceneRenderer, pSkyDome, pAtmosphereScatter, pGraphicsDev->GetScreenSize() );
				hud.Open( &uiManager );
			}

			MIX_RELEASE( pFont_12_200 );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pEngine->ResetFPS();

		while( pEngine->Update() == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// z
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( ( pDirLight != NULL ) &&
				( pAtmosphereScatter != NULL ) )
			{
				pDirLight->SetDirection( pSkyDome->GetSunLight().dir );
				pDirLight->SetColor( pAtmosphereScatter->GetSunLightColor() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// J
			////////////////////////////////////////////////////////////////////////////////////////////////////

			viewCamHelper.Update();

			if( pCamera != NULL )
			{
				pCamera->SetRotation( viewCamHelper.GetRotation() );
				pCamera->SetAt( viewCamHelper.GetAt() );
				pCamera->SetDistance( viewCamHelper.GetDistance() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// LoX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCanvasRenderer != NULL )
			{
				tempStr.Sprintf(	L"FPS  [%f]\n"
									L"STPS [%f]\n"
									L"IF   [%d/%d]",	pEngine->GetFPS(),
														pEngine->GetSleepTimePerSec(),
														pEngine->GetInsomniaFrameCountPerSec(), pEngine->GetInsomniaFrameMax() );

				pCanvasRenderer->SetColor(		Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
				pCanvasRenderer->AddString(	16.0f, 16.0f, tempStr.GetConstPtr() );
				pCanvasRenderer->AddString(	16.0f, pGraphicsDev->GetScreenSize().y - 112.0f,
									L"Controls :\n"
									L"  Rotate camera  : Mouse middle button\n"
									L"  Move camera    : Mouse middle button + Shift key\n"
									L"  Distant camera : Mouse middle button + Ctrl key or Mouse wheel\n"
									L"  Rotate light   : Mouse right button" );

				uiManager.Update();

				Utility::DrawMouseCursor( pCanvasRenderer, pMouse->GetPos() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCamera != NULL )
			{
				pCamera->Update();
			}

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Update( pEngine->GetDT() );
			}

			if( pCanvasRenderer != NULL )
			{
				pCanvasRenderer->Update();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tbV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Refresh();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// `
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );

			if( pGraphicsDev->Begin() == True )
			{
				if( pCamera != NULL )
				{
					pCamera->Draw();
				}

				if( pCanvasRenderer != NULL )
				{
					pCanvasRenderer->Draw();
				}

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		uiManager.Dispose();
		viewCamHelper.Dispose();

		MIX_RELEASE( pAtmosphereScatter );
		MIX_RELEASE( pSkyDome );
		MIX_RELEASE( pDirLight );
		MIX_RELEASE( pCamera );
		MIX_RELEASE( pSceneRenderer );
		MIX_RELEASE( pSceneEffectPackage );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pKeyboard );
		MIX_RELEASE( pMouse );

		Mix::Finalize();
	}


	return 0;
}
