#include "ambientDialog.h"
#include "Mix/Scene/IRenderer.h"

AmbientDialog::AmbientDialog( void ) :
m_pSceneRenderer( NULL )
{
}

AmbientDialog::~AmbientDialog( void )
{
}

void AmbientDialog::Initialize( Mix::Scene::IRenderer* pSceneRenderer )
{
	MIX_ASSERT( pSceneRenderer );

	MIX_ADD_REF( pSceneRenderer );
	m_pSceneRenderer = pSceneRenderer;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// g̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	SetCaption( L"Ambient" );
	SetPosition( Mix::Vector2( 256.0f, 128.0f ) );
	SetSize( Mix::Point( AmbientDialog::DLG_WIDTH, AmbientDialog::DLG_HEIGHT ) );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Rg[̒ǉ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	const Mix::Vector4& ambientColor = m_pSceneRenderer->GetGlobalAmbientColor();
	Int32 itemY = AmbientDialog::ITEM_Y;

	m_ColorC.SetPosition( Mix::Point( AmbientDialog::ITEM_X, itemY ) );
	m_ColorC.SetSize( Mix::Point( AmbientDialog::ITEM_WIDTH, AmbientDialog::ITEM_HEIGHT ) );
	m_ColorC.SetText( L"" );
	m_ColorC.SetAlphaEnabled( False );
	m_ColorC.SetValue( ambientColor );
	m_ColorC.Initialize( this, AmbientDialog::CTRL_COLOR_C );
	itemY += AmbientDialog::ITEM_Y_STEP;

	m_RedSF.SetPosition( Mix::Point( AmbientDialog::ITEM_X, itemY ) );
	m_RedSF.SetSize( Mix::Point( AmbientDialog::ITEM_WIDTH, AmbientDialog::ITEM_HEIGHT ) );
	m_RedSF.SetText( L"R" );
	m_RedSF.SetRange( 0.0f, 1.0f );
	m_RedSF.SetStep( 0.01f );
	m_RedSF.SetValue( ambientColor.r );
	m_RedSF.Initialize( this, AmbientDialog::CTRL_RED_SF );
	itemY += AmbientDialog::ITEM_Y_STEP;

	m_GreenSF.SetPosition( Mix::Point( AmbientDialog::ITEM_X, itemY ) );
	m_GreenSF.SetSize( Mix::Point( AmbientDialog::ITEM_WIDTH, AmbientDialog::ITEM_HEIGHT ) );
	m_GreenSF.SetText( L"G" );
	m_GreenSF.SetRange( 0.0f, 1.0f );
	m_GreenSF.SetStep( 0.01f );
	m_GreenSF.SetValue( ambientColor.g );
	m_GreenSF.Initialize( this, AmbientDialog::CTRL_GREEN_SF );
	itemY += AmbientDialog::ITEM_Y_STEP;

	m_BlueSF.SetPosition( Mix::Point( AmbientDialog::ITEM_X, itemY ) );
	m_BlueSF.SetSize( Mix::Point( AmbientDialog::ITEM_WIDTH, AmbientDialog::ITEM_HEIGHT ) );
	m_BlueSF.SetText( L"B" );
	m_BlueSF.SetRange( 0.0f, 1.0f );
	m_BlueSF.SetStep( 0.01f );
	m_BlueSF.SetValue( ambientColor.b );
	m_BlueSF.Initialize( this, AmbientDialog::CTRL_BLUE_SF );
	itemY += AmbientDialog::ITEM_Y_STEP;
}

void AmbientDialog::OnDispose( void )
{
	MIX_RELEASE( m_pSceneRenderer );
}

void AmbientDialog::OnSlider_ValueChanged( Utility::UI::SliderF* pSlider )
{
	Mix::Vector4 color = m_pSceneRenderer->GetGlobalAmbientColor();

	switch( pSlider->GetID() )
	{
	case AmbientDialog::CTRL_RED_SF:
		color.r = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	case AmbientDialog::CTRL_GREEN_SF:
		color.g = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	case AmbientDialog::CTRL_BLUE_SF:
		color.b = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	}
}

void AmbientDialog::OnColor_ValueChanged( Utility::UI::Color* pColor )
{
	switch( pColor->GetID() )
	{
	case AmbientDialog::CTRL_COLOR_C:
		m_pSceneRenderer->SetGlobalAmbientColor( pColor->GetValue() );
		break;
	}
}
