#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Color.h"
#include "Utility/UI/Slider.h"

class AmbientDialog : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH	= 144,
		DLG_HEIGHT	= 124,

		ITEM_X		= 4,
		ITEM_Y		= 4,
		ITEM_WIDTH	= 128,
		ITEM_HEIGHT	= 20,

		ITEM_Y_STEP	= 24,
	};

	enum CTRL_ID
	{
		CTRL_COLOR_C	= 0,
		CTRL_RED_SF		= 1,
		CTRL_GREEN_SF	= 2,
		CTRL_BLUE_SF	= 3,
	};

private:
	Mix::Scene::IRenderer* m_pSceneRenderer;

	Utility::UI::Color m_ColorC;
	Utility::UI::SliderF m_RedSF;
	Utility::UI::SliderF m_GreenSF;
	Utility::UI::SliderF m_BlueSF;

public:
	AmbientDialog( void );
	~AmbientDialog( void );

	void Initialize( Mix::Scene::IRenderer* pSceneRenderer );

protected:
	virtual void OnDispose( void );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnColor_ValueChanged( Utility::UI::Color* pColor );
};
