#include "directionalDialog.h"
#include "Mix/Scene/IRenderer.h"
#include "Mix/Scene/ICamera.h"
#include "Mix/Scene/IDirectionalLight.h"

DirectionalDialog::DirectionalDialog( void ) :
m_pCamera( NULL ),
m_pLight( NULL )
{
}

DirectionalDialog::~DirectionalDialog( void )
{
}

void DirectionalDialog::Initialize( Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera )
{
	MIX_ASSERT( pSceneRenderer != NULL );
	MIX_ASSERT( pCamera != NULL );
	MIX_ASSERT( m_pCamera == NULL );
	MIX_ASSERT( m_pLight == NULL );

	MIX_ADD_REF( pCamera );
	m_pCamera = pCamera;

	pSceneRenderer->GetDirectionalLight( &m_pLight );
	MIX_ASSERT( m_pLight != NULL );

	m_pLight->SetEnabled( True );
	m_pLight->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 0.1905f ) );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// g̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	SetCaption( L"Directional" );
	SetPosition( Mix::Vector2( 256.0f, 128.0f ) );
	SetSize( Mix::Point( DirectionalDialog::DLG_WIDTH, DirectionalDialog::DLG_HEIGHT ) );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Rg[̒ǉ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Boolean bDisplayDir = ( MIX_TESTBIT( m_pCamera->Debug_GetDrawFlags(), Mix::Scene::DDF_DIRLIGHT_SHAPE ) == Mix::Scene::DDF_DIRLIGHT_SHAPE );
	const Mix::Vector4& color = m_pLight->GetColor();
	Int32 itemY = DirectionalDialog::ITEM_Y;

	m_EnabledCB.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_EnabledCB.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_EnabledCB.SetText( L"Enabled" );
	m_EnabledCB.SetState( m_pLight->IsEnabled() );
	m_EnabledCB.Initialize( this, DirectionalDialog::CTRL_ENABLED_CB );
	itemY += DirectionalDialog::ITEM_Y_STEP;

#ifdef _DEBUG

	m_DisplayDirectionCB.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_DisplayDirectionCB.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_DisplayDirectionCB.SetText( L"Display direction" );
	m_DisplayDirectionCB.SetState( bDisplayDir );
	m_DisplayDirectionCB.Initialize( this, DirectionalDialog::CTRL_DISPLAY_DIR_CB );
	itemY += DirectionalDialog::ITEM_Y_STEP;

#endif //_DEBUG

	m_ColorC.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_ColorC.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_ColorC.SetText( L"" );
	m_ColorC.SetAlphaEnabled( True );
	m_ColorC.SetValue( color );
	m_ColorC.Initialize( this, DirectionalDialog::CTRL_COLOR_C );
	itemY += DirectionalDialog::ITEM_Y_STEP;

	m_RedSF.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_RedSF.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_RedSF.SetText( L"R" );
	m_RedSF.SetRange( 0.0f, 1.0f );
	m_RedSF.SetStep( 0.01f );
	m_RedSF.SetValue( color.r );
	m_RedSF.Initialize( this, DirectionalDialog::CTRL_RED_SF );
	itemY += DirectionalDialog::ITEM_Y_STEP;

	m_GreenSF.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_GreenSF.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_GreenSF.SetText( L"G" );
	m_GreenSF.SetRange( 0.0f, 1.0f );
	m_GreenSF.SetStep( 0.01f );
	m_GreenSF.SetValue( color.g );
	m_GreenSF.Initialize( this, DirectionalDialog::CTRL_GREEN_SF );
	itemY += DirectionalDialog::ITEM_Y_STEP;

	m_BlueSF.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_BlueSF.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_BlueSF.SetText( L"B" );
	m_BlueSF.SetRange( 0.0f, 1.0f );
	m_BlueSF.SetStep( 0.01f );
	m_BlueSF.SetValue( color.b );
	m_BlueSF.Initialize( this, DirectionalDialog::CTRL_BLUE_SF );
	itemY += DirectionalDialog::ITEM_Y_STEP;

	m_AlphaSF.SetPosition( Mix::Point( DirectionalDialog::ITEM_X, itemY ) );
	m_AlphaSF.SetSize( Mix::Point( DirectionalDialog::ITEM_WIDTH, DirectionalDialog::ITEM_HEIGHT ) );
	m_AlphaSF.SetText( L"A" );
	m_AlphaSF.SetRange( 0.0f, 1.0f );
	m_AlphaSF.SetStep( 0.01f );
	m_AlphaSF.SetValue( color.a );
	m_AlphaSF.Initialize( this, DirectionalDialog::CTRL_ALPHA_SF );
	itemY += DirectionalDialog::ITEM_Y_STEP;
}

void DirectionalDialog::OnDispose( void )
{
	MIX_RELEASE( m_pLight );
	MIX_RELEASE( m_pCamera );
}

void DirectionalDialog::OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox )
{
	UInt32 ddFlags;

	switch( pCheckBox->GetID() )
	{
	case DirectionalDialog::CTRL_ENABLED_CB:
		m_pLight->SetEnabled( pCheckBox->GetState() );
		break;
	case DirectionalDialog::CTRL_DISPLAY_DIR_CB:
		ddFlags = m_pCamera->Debug_GetDrawFlags();
		if( pCheckBox->GetState() == True )
		{
			MIX_SETBIT( ddFlags, Mix::Scene::DDF_DIRLIGHT_SHAPE );
		}
		else
		{
			MIX_RESETBIT( ddFlags, Mix::Scene::DDF_DIRLIGHT_SHAPE );
		}
		m_pCamera->Debug_SetDrawFlags( ddFlags );
		break;
	}
}

void DirectionalDialog::OnSlider_ValueChanged( Utility::UI::SliderF* pSlider )
{
	Mix::Vector4 color = m_pLight->GetColor();

	switch( pSlider->GetID() )
	{
	case DirectionalDialog::CTRL_RED_SF:
		color.r = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	case DirectionalDialog::CTRL_GREEN_SF:
		color.g = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	case DirectionalDialog::CTRL_BLUE_SF:
		color.b = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	case DirectionalDialog::CTRL_ALPHA_SF:
		color.a = pSlider->GetValue();
		m_ColorC.SetValue( color );
		break;
	}
}

void DirectionalDialog::OnColor_ValueChanged( Utility::UI::Color* pColor )
{
	switch( pColor->GetID() )
	{
	case DirectionalDialog::CTRL_COLOR_C:
		m_pLight->SetColor( pColor->GetValue() );
		break;
	}
}
