#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Color.h"
#include "Utility/UI/Slider.h"

class DirectionalDialog : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH	= 144,

#ifdef _DEBUG
		DLG_HEIGHT	= 196,
#else //_DEBUG
		DLG_HEIGHT	= 172,
#endif //_DEBUG

		ITEM_X		= 4,
		ITEM_Y		= 4,
		ITEM_WIDTH	= 128,
		ITEM_HEIGHT	= 20,

		ITEM_Y_STEP	= 24,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB		= 0,
		CTRL_DISPLAY_DIR_CB	= 1,
		CTRL_COLOR_C		= 2,
		CTRL_RED_SF			= 3,
		CTRL_GREEN_SF		= 4,
		CTRL_BLUE_SF		= 5,
		CTRL_ALPHA_SF		= 6,
	};

private:
	Mix::Scene::ICamera* m_pCamera;
	Mix::Scene::IDirectionalLight* m_pLight;

	Utility::UI::CheckBox m_EnabledCB;

#ifdef _DEBUG
	Utility::UI::CheckBox m_DisplayDirectionCB;
#endif //_DEBUG

	Utility::UI::Color m_ColorC;
	Utility::UI::SliderF m_RedSF;
	Utility::UI::SliderF m_GreenSF;
	Utility::UI::SliderF m_BlueSF;
	Utility::UI::SliderF m_AlphaSF;

public:
	DirectionalDialog( void );
	~DirectionalDialog( void );

	void Initialize( Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnColor_ValueChanged( Utility::UI::Color* pColor );
};
