#include "hemisphereDialog.h"

#include "Mix/Scene/IManager.h"
#include "Mix/Scene/IRenderer.h"
#include "Mix/Scene/IHemisphereLight.h"

HemisphereDialog::HemisphereDialog( void ) :
m_pLight( NULL )
{
}

HemisphereDialog::~HemisphereDialog( void )
{
}

void HemisphereDialog::Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer )
{
	MIX_ASSERT( pSceneManager != NULL );
	MIX_ASSERT( pSceneRenderer != NULL );

	if( pSceneManager->CreateHemisphereLight( &m_pLight ) == True )
	{
		m_pLight->SetEnabled( True );
		m_pLight->SetAxis( Mix::Vector3( 0.0f, 1.0f, 0.0f ) );
		m_pLight->SetSkyColor( Mix::Vector4( 0.1032f, 0.1667f, 0.3095f, 0.2937f ) );
		m_pLight->SetGroundColor( Mix::Vector4( 0.1746f, 0.1329f, 0.1349f, 0.8f ) );

		pSceneRenderer->SetHemisphereLight( m_pLight );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// g̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	SetCaption( L"Hemisphere" );
	SetPosition( Mix::Vector2( 256.0f, 128.0f ) );
	SetSize( Mix::Point( HemisphereDialog::DLG_WIDTH, HemisphereDialog::DLG_HEIGHT ) );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Rg[̒ǉ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	const Mix::Vector4& ceilingColor = m_pLight->GetSkyColor();
	const Mix::Vector4& floorColor = m_pLight->GetGroundColor();

	Int32 itemY = HemisphereDialog::ITEM_Y;

	m_EnabledCB.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_EnabledCB.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_EnabledCB.SetText( L"Enabled" );
	m_EnabledCB.SetState( m_pLight->IsEnabled() );
	m_EnabledCB.Initialize( this, HemisphereDialog::CTRL_ENABLED_CB );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_CeilingColorC.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_CeilingColorC.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_CeilingColorC.SetText( L"Ceiling" );
	m_CeilingColorC.SetAlphaEnabled( True );
	m_CeilingColorC.SetValue( ceilingColor );
	m_CeilingColorC.Initialize( this, HemisphereDialog::CTRL_CEILING_COLOR_C );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_CeilingRedSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_CeilingRedSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_CeilingRedSF.SetText( L"R" );
	m_CeilingRedSF.SetRange( 0.0f, 1.0f );
	m_CeilingRedSF.SetStep( 0.01f );
	m_CeilingRedSF.SetValue( ceilingColor.r );
	m_CeilingRedSF.Initialize( this, HemisphereDialog::CTRL_CEILING_RED_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_CeilingGreenSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_CeilingGreenSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_CeilingGreenSF.SetText( L"G" );
	m_CeilingGreenSF.SetRange( 0.0f, 1.0f );
	m_CeilingGreenSF.SetStep( 0.01f );
	m_CeilingGreenSF.SetValue( ceilingColor.g );
	m_CeilingGreenSF.Initialize( this, HemisphereDialog::CTRL_CEILING_GREEN_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_CeilingBlueSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_CeilingBlueSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_CeilingBlueSF.SetText( L"B" );
	m_CeilingBlueSF.SetRange( 0.0f, 1.0f );
	m_CeilingBlueSF.SetStep( 0.01f );
	m_CeilingBlueSF.SetValue( ceilingColor.b );
	m_CeilingBlueSF.Initialize( this, HemisphereDialog::CTRL_CEILING_BLUE_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_CeilingAlphaSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_CeilingAlphaSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_CeilingAlphaSF.SetText( L"A" );
	m_CeilingAlphaSF.SetRange( 0.0f, 1.0f );
	m_CeilingAlphaSF.SetStep( 0.01f );
	m_CeilingAlphaSF.SetValue( ceilingColor.a );
	m_CeilingAlphaSF.Initialize( this, HemisphereDialog::CTRL_CEILING_ALPHA_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_FloorColorC.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_FloorColorC.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_FloorColorC.SetText( L"Floor" );
	m_FloorColorC.SetAlphaEnabled( True );
	m_FloorColorC.SetValue( floorColor );
	m_FloorColorC.Initialize( this, HemisphereDialog::CTRL_FLOOR_COLOR_C );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_FloorRedSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_FloorRedSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_FloorRedSF.SetText( L"R" );
	m_FloorRedSF.SetRange( 0.0f, 1.0f );
	m_FloorRedSF.SetStep( 0.01f );
	m_FloorRedSF.SetValue( floorColor.r );
	m_FloorRedSF.Initialize( this, HemisphereDialog::CTRL_FLOOR_RED_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_FloorGreenSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_FloorGreenSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_FloorGreenSF.SetText( L"G" );
	m_FloorGreenSF.SetRange( 0.0f, 1.0f );
	m_FloorGreenSF.SetStep( 0.01f );
	m_FloorGreenSF.SetValue( floorColor.g );
	m_FloorGreenSF.Initialize( this, HemisphereDialog::CTRL_FLOOR_GREEN_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_FloorBlueSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_FloorBlueSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_FloorBlueSF.SetText( L"B" );
	m_FloorBlueSF.SetRange( 0.0f, 1.0f );
	m_FloorBlueSF.SetStep( 0.01f );
	m_FloorBlueSF.SetValue( floorColor.b );
	m_FloorBlueSF.Initialize( this, HemisphereDialog::CTRL_FLOOR_BLUE_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;

	m_FloorAlphaSF.SetPosition( Mix::Point( HemisphereDialog::ITEM_X, itemY ) );
	m_FloorAlphaSF.SetSize( Mix::Point( HemisphereDialog::ITEM_WIDTH, HemisphereDialog::ITEM_HEIGHT ) );
	m_FloorAlphaSF.SetText( L"A" );
	m_FloorAlphaSF.SetRange( 0.0f, 1.0f );
	m_FloorAlphaSF.SetStep( 0.01f );
	m_FloorAlphaSF.SetValue( floorColor.a );
	m_FloorAlphaSF.Initialize( this, HemisphereDialog::CTRL_FLOOR_ALPHA_SF );
	itemY += HemisphereDialog::ITEM_Y_STEP;
}

void HemisphereDialog::OnDispose( void )
{
	MIX_RELEASE( m_pLight );
}

void HemisphereDialog::OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox )
{
	switch( pCheckBox->GetID() )
	{
	case HemisphereDialog::CTRL_ENABLED_CB:
		m_pLight->SetEnabled( pCheckBox->GetState() );
		break;
	}
}

void HemisphereDialog::OnSlider_ValueChanged( Utility::UI::SliderF* pSlider )
{
	Mix::Vector4 ceilingColor = m_pLight->GetSkyColor();
	Mix::Vector4 floorColor = m_pLight->GetGroundColor();

	switch( pSlider->GetID() )
	{
	case HemisphereDialog::CTRL_CEILING_RED_SF:
		ceilingColor.r = pSlider->GetValue();
		m_CeilingColorC.SetValue( ceilingColor );
		break;
	case HemisphereDialog::CTRL_CEILING_GREEN_SF:
		ceilingColor.g = pSlider->GetValue();
		m_CeilingColorC.SetValue( ceilingColor );
		break;
	case HemisphereDialog::CTRL_CEILING_BLUE_SF:
		ceilingColor.b = pSlider->GetValue();
		m_CeilingColorC.SetValue( ceilingColor );
		break;
	case HemisphereDialog::CTRL_CEILING_ALPHA_SF:
		ceilingColor.a = pSlider->GetValue();
		m_CeilingColorC.SetValue( ceilingColor );
		break;

	case HemisphereDialog::CTRL_FLOOR_RED_SF:
		floorColor.r = pSlider->GetValue();
		m_FloorColorC.SetValue( floorColor );
		break;
	case HemisphereDialog::CTRL_FLOOR_GREEN_SF:
		floorColor.g = pSlider->GetValue();
		m_FloorColorC.SetValue( floorColor );
		break;
	case HemisphereDialog::CTRL_FLOOR_BLUE_SF:
		floorColor.b = pSlider->GetValue();
		m_FloorColorC.SetValue( floorColor );
		break;
	case HemisphereDialog::CTRL_FLOOR_ALPHA_SF:
		floorColor.a = pSlider->GetValue();
		m_FloorColorC.SetValue( floorColor );
		break;
	}
}

void HemisphereDialog::OnColor_ValueChanged( Utility::UI::Color* pColor )
{
	switch( pColor->GetID() )
	{
	case HemisphereDialog::CTRL_CEILING_COLOR_C:
		m_pLight->SetSkyColor( pColor->GetValue() );
		break;
	case HemisphereDialog::CTRL_FLOOR_COLOR_C:
		m_pLight->SetGroundColor( pColor->GetValue() );
		break;
	}
}
