#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Color.h"
#include "Utility/UI/Slider.h"

class HemisphereDialog : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH	= 144,
		DLG_HEIGHT	= 292,

		ITEM_X		= 4,
		ITEM_Y		= 4,
		ITEM_WIDTH	= 128,
		ITEM_HEIGHT	= 20,

		ITEM_Y_STEP	= 24,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB			= 0,
		CTRL_CEILING_COLOR_C	= 1,
		CTRL_CEILING_RED_SF		= 2,
		CTRL_CEILING_GREEN_SF	= 3,
		CTRL_CEILING_BLUE_SF	= 4,
		CTRL_CEILING_ALPHA_SF	= 5,
		CTRL_FLOOR_COLOR_C		= 6,
		CTRL_FLOOR_RED_SF		= 7,
		CTRL_FLOOR_GREEN_SF		= 8,
		CTRL_FLOOR_BLUE_SF		= 9,
		CTRL_FLOOR_ALPHA_SF		= 10,
	};

private:
	Mix::Scene::IHemisphereLight* m_pLight;

	Utility::UI::CheckBox m_EnabledCB;
	Utility::UI::Color m_CeilingColorC;
	Utility::UI::SliderF m_CeilingRedSF;
	Utility::UI::SliderF m_CeilingGreenSF;
	Utility::UI::SliderF m_CeilingBlueSF;
	Utility::UI::SliderF m_CeilingAlphaSF;
	Utility::UI::Color m_FloorColorC;
	Utility::UI::SliderF m_FloorRedSF;
	Utility::UI::SliderF m_FloorGreenSF;
	Utility::UI::SliderF m_FloorBlueSF;
	Utility::UI::SliderF m_FloorAlphaSF;

public:
	HemisphereDialog( void );
	~HemisphereDialog( void );

	void Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnColor_ValueChanged( Utility::UI::Color* pColor );
};
