#include "hud.h"

#include "Mix/Scene/IManager.h"
#include "Mix/Scene/IRenderer.h"
#include "Mix/Scene/ICamera.h"

HUD::HUD( void )
{
}

HUD::~HUD( void )
{
}

void HUD::Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera )
{
	MIX_ASSERT( pSceneManager != NULL );
	MIX_ASSERT( pSceneRenderer != NULL );
	MIX_ASSERT( pCamera != NULL );

	const Mix::Point& screenSize = pCamera->GetConfig().targetSize;

	SetHUDEnabled( True );
	SetPosition( Mix::Point( screenSize.x - HUD::DLG_WIDTH, screenSize.y - HUD::DLG_HEIGHT ) );
	SetSize( Mix::Point( HUD::DLG_WIDTH, HUD::DLG_HEIGHT ) );

	m_AmbientDlg.Initialize( pSceneRenderer );
	m_HemisphereDlg.Initialize( pSceneManager, pSceneRenderer );
	m_DirectionalDlg.Initialize( pSceneRenderer, pCamera );
	m_SpotDlg.Initialize( pSceneManager, pSceneRenderer, pCamera );
	m_PointDlg.Initialize( pSceneManager, pSceneRenderer, pCamera );
}

void HUD::OnOpen( void )
{
	Int32 itemY = 16;

	m_AmbientB.SetPosition( Mix::Point( HUD::ITEM_X, itemY ) );
	m_AmbientB.SetSize( Mix::Point( HUD::ITEM_WIDTH, HUD::ITEM_HEIGHT ) );
	m_AmbientB.SetText( L"Ambient" );
	m_AmbientB.Initialize( this, HUD::CTRL_AMBIENT_B );
	itemY += HUD::ITEM_Y_STEP;

	m_HemisphereB.SetPosition( Mix::Point( HUD::ITEM_X, itemY ) );
	m_HemisphereB.SetSize( Mix::Point( HUD::ITEM_WIDTH, HUD::ITEM_HEIGHT ) );
	m_HemisphereB.SetText( L"Hemisphere" );
	m_HemisphereB.Initialize( this, HUD::CTRL_HEMISPHERE_B );
	itemY += HUD::ITEM_Y_STEP;

	m_DirectionalB.SetPosition( Mix::Point( HUD::ITEM_X, itemY ) );
	m_DirectionalB.SetSize( Mix::Point( HUD::ITEM_WIDTH, HUD::ITEM_HEIGHT ) );
	m_DirectionalB.SetText( L"Directional" );
	m_DirectionalB.Initialize( this, HUD::CTRL_DIRECTIONAL_B );
	itemY += HUD::ITEM_Y_STEP;

	m_SpotB.SetPosition( Mix::Point( HUD::ITEM_X, itemY ) );
	m_SpotB.SetSize( Mix::Point( HUD::ITEM_WIDTH, HUD::ITEM_HEIGHT ) );
	m_SpotB.SetText( L"Spot" );
	m_SpotB.Initialize( this, HUD::CTRL_SPOT_B );
	itemY += HUD::ITEM_Y_STEP;

	m_PointB.SetPosition( Mix::Point( HUD::ITEM_X, itemY ) );
	m_PointB.SetSize( Mix::Point( HUD::ITEM_WIDTH, HUD::ITEM_HEIGHT ) );
	m_PointB.SetText( L"Point" );
	m_PointB.Initialize( this, HUD::CTRL_POINT_B );
	itemY += HUD::ITEM_Y_STEP;
}

void HUD::OnDispose( void )
{
	m_AmbientDlg.Dispose();
	m_HemisphereDlg.Dispose();
	m_DirectionalDlg.Dispose();
	m_SpotDlg.Dispose();
	m_PointDlg.Dispose();
}

void HUD::OnButton_Click( Utility::UI::Button* pButton )
{
	switch( pButton->GetID() )
	{
	case HUD::CTRL_AMBIENT_B:
		m_AmbientDlg.Open( GetManager() );
		break;
	case HUD::CTRL_HEMISPHERE_B:
		m_HemisphereDlg.Open( GetManager() );
		break;
	case HUD::CTRL_DIRECTIONAL_B:
		m_DirectionalDlg.Open( GetManager() );
		break;
	case HUD::CTRL_SPOT_B:
		m_SpotDlg.Open( GetManager() );
		break;
	case HUD::CTRL_POINT_B:
		m_PointDlg.Open( GetManager() );
		break;
	}
}
