#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Button.h"

#include "ambientDialog.h"
#include "hemisphereDialog.h"
#include "directionalDialog.h"
#include "spotDialog.h"
#include "pointDialog.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH			= 144,
		DLG_HEIGHT			= 150,

		ITEM_X				= 0,
		ITEM_WIDTH			= 128,
		ITEM_HEIGHT			= 20,

		ITEM_Y_STEP			= 24,
	};

	enum CTRL_ID
	{
		CTRL_AMBIENT_B				= 0,
		CTRL_HEMISPHERE_B			= 1,
		CTRL_DIRECTIONAL_B			= 2,
		CTRL_SPOT_B					= 3,
		CTRL_POINT_B				= 4,
	};

private:
	Utility::UI::Button m_AmbientB;
	Utility::UI::Button m_HemisphereB;
	Utility::UI::Button m_DirectionalB;
	Utility::UI::Button m_SpotB;
	Utility::UI::Button m_PointB;

	AmbientDialog m_AmbientDlg;
	HemisphereDialog m_HemisphereDlg;
	DirectionalDialog m_DirectionalDlg;
	SpotDialog m_SpotDlg;
	PointDialog m_PointDlg;

public:
	HUD( void );
	~HUD( void );

public:
	void Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnOpen( void );
	virtual void OnDispose( void );
	virtual void OnButton_Click( Utility::UI::Button* pButton );
};
