#pragma once

#include <list>

#include "Utility/UI/Dialog.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Color.h"
#include "Utility/UI/Slider.h"

class PointDialog : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH	= 144,

#ifdef _DEBUG
		DLG_HEIGHT	= 316,
#else //_DEBUG
		DLG_HEIGHT	= 292,
#endif //_DEBUG

		ITEM_X		= 4,
		ITEM_Y		= 4,
		ITEM_WIDTH	= 128,
		ITEM_HEIGHT	= 20,

		ITEM_Y_STEP	= 24,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB			= 0,
		CTRL_DISPLAY_BOUNDS_CB	= 1,

		CTRL_COLOR_C			= 2,
		CTRL_RED_SF				= 3,
		CTRL_GREEN_SF			= 4,
		CTRL_BLUE_SF			= 5,
		CTRL_ALPHA_SF			= 6,

		CTRL_L_ATTEN_SF			= 7,
		CTRL_Q_ATTEN_SF			= 8,
		CTRL_E_ATTEN_SF			= 9,

		CTRL_INNER_RADIUS_SF	= 10,
		CTRL_OUTER_RADIUS_SF	= 11,
	};

	typedef std::vector<Mix::Scene::IPointLight*> LightList;

private:
	Mix::Scene::ICamera* m_pCamera;
	PointDialog::LightList m_LightList;

	Utility::UI::CheckBox m_EnabledCB;

#ifdef _DEBUG
	Utility::UI::CheckBox m_DisplayBoundsCB;
#endif //_DEBUG

	Utility::UI::Color m_ColorC;
	Utility::UI::SliderF m_RedSF;
	Utility::UI::SliderF m_GreenSF;
	Utility::UI::SliderF m_BlueSF;
	Utility::UI::SliderF m_AlphaSF;

	Utility::UI::SliderF m_LAttenSF;
	Utility::UI::SliderF m_QAttenSF;
	Utility::UI::SliderF m_EAttenSF;

	Utility::UI::SliderF m_InnerRadiusSF;
	Utility::UI::SliderF m_OuterRadiusSF;

public:
	PointDialog( void );
	~PointDialog( void );

	void Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnColor_ValueChanged( Utility::UI::Color* pColor );
};
