#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Color.h"
#include "Utility/UI/Slider.h"

class SpotDialog : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH	= 144,

#ifdef _DEBUG
		DLG_HEIGHT	= 388,
#else //_DEBUG
		DLG_HEIGHT	= 340,
#endif //_DEBUG

		ITEM_X		= 4,
		ITEM_Y		= 4,
		ITEM_WIDTH	= 128,
		ITEM_HEIGHT	= 20,

		ITEM_Y_STEP	= 24,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB			= 0,
		CTRL_DISPLAY_CONE_CB	= 1,
		CTRL_DISPLAY_BOUNDS_CB	= 2,

		CTRL_COLOR_C			= 3,
		CTRL_RED_SF				= 4,
		CTRL_GREEN_SF			= 5,
		CTRL_BLUE_SF			= 6,
		CTRL_ALPHA_SF			= 7,

		CTRL_EXPONENT_SF		= 8,

		CTRL_L_ATTEN_SF			= 9,
		CTRL_Q_ATTEN_SF			= 10,
		CTRL_E_ATTEN_SF			= 11,

		CTRL_INNER_ANGLE_SF		= 12,
		CTRL_OUTER_ANGLE_SF		= 13,

		CTRL_RANGE_SF			= 14,
	};

private:
	Mix::Scene::ICamera* m_pCamera;
	Mix::Scene::ISpotLight* m_pLight;

	Utility::UI::CheckBox m_EnabledCB;

#ifdef _DEBUG
	Utility::UI::CheckBox m_DisplayConeCB;
	Utility::UI::CheckBox m_DisplayBoundsCB;
#endif //_DEBUG

	Utility::UI::Color m_ColorC;
	Utility::UI::SliderF m_RedSF;
	Utility::UI::SliderF m_GreenSF;
	Utility::UI::SliderF m_BlueSF;
	Utility::UI::SliderF m_AlphaSF;

	Utility::UI::SliderF m_ExponentSF;

	Utility::UI::SliderF m_LAttenSF;
	Utility::UI::SliderF m_QAttenSF;
	Utility::UI::SliderF m_EAttenSF;

	Utility::UI::SliderF m_InnerAngleSF;
	Utility::UI::SliderF m_OuterAngleSF;

	Utility::UI::SliderF m_RangeSF;

public:
	SpotDialog( void );
	~SpotDialog( void );

	void Initialize( Mix::Scene::IManager* pSceneManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnColor_ValueChanged( Utility::UI::Color* pColor );
};
