#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Button.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/ComboBox.h"
#include "Utility/UI/Label.h"
#include "Utility/UI/Slider.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 230,
		DLG_HEIGHT		= 200 + 128 - 48,

		ITEM_X			= 80,
		ITEM_WIDTH		= 128,
		ITEM_HEIGHT		= 20,

		ITEM_X1			= ITEM_X,
		ITEM_WIDTH1		= ITEM_WIDTH / 8 * 5 - 1,
		ITEM_HEIGHT1	= ITEM_HEIGHT,

		ITEM_X2			= ITEM_X1 + ITEM_WIDTH1 + 2,
		ITEM_WIDTH2		= ITEM_WIDTH / 8 * 3 - 1,
		ITEM_HEIGHT2	= ITEM_HEIGHT,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= ITEM_Y_STEP + 8,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB		= 0,

		CTRL_BOKEH_L		= 1,
		CTRL_SMPL_CB		= 2,
		CTRL_BLUR_TYPE_CB	= 3,
		CTRL_BLUR_VALUE_SI	= 4,

		CTRL_DISTO_L		= 5,
		CTRL_K_SF			= 6,
		CTRL_K_CUBE_SF		= 7,
		CTRL_WEIGHT_SF		= 8,
		CTRL_DIST_SF		= 9,

#ifdef _DEBUG
		CTRL_DEBUG_CB		= 10,
#endif //_DEBUG
	};

private:
	Mix::Scene::ICamera* m_pCamera;
	Mix::Graphics::ITexture* m_pTex;

	Utility::UI::CheckBox m_EnabledCB;

	Utility::UI::Label m_BokehL;
	Utility::UI::ComboBox m_SmplCB;
	Utility::UI::ComboBox m_BlurCB;
	Utility::UI::SliderI m_BlurSI;

	Utility::UI::Label m_DistoL;
	Utility::UI::SliderF m_KSF;
	Utility::UI::SliderF m_KCubeSF;
	Utility::UI::SliderF m_DriftSF;
	Utility::UI::SliderF m_DistSF;

	Mix::Scene::BLUR m_BlurTable[Mix::Scene::BLUR::TYPE_MAX];

	static const Int32 SMOOTH_RANGE_TABLE[Mix::Scene::BLUR::TYPE_MAX][2];

#ifdef _DEBUG
	Utility::UI::CheckBox m_DebugCB;
#endif //_DEBUG

private:
	static Int32 GetSmoothValue( const Mix::Scene::BLUR& blur );
	static void SetSmoothValue( Mix::Scene::BLUR& blur, Int32 value );

public:
	HUD( void );
	virtual ~HUD( void );

public:
	void Initialize( const Mix::Point& screenSize, Mix::Scene::ICamera* pCamera, Mix::Graphics::ITexture* pTex );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider );
	virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox );
};
