#pragma once

#include "Utility/UI.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 166,
		DLG_HEIGHT		= 296,

		ITEM_X			= 0,
		ITEM_WIDTH		= 144,
		ITEM_HEIGHT		= 20,

		ITEM_X1			= ITEM_X,
		ITEM_WIDTH1		= ITEM_WIDTH / 8 * 5 - 1,
		ITEM_HEIGHT1	= ITEM_HEIGHT,

		ITEM_X2			= ITEM_X1 + ITEM_WIDTH1 + 2,
		ITEM_WIDTH2		= ITEM_WIDTH / 8 * 3 - 1,
		ITEM_HEIGHT2	= ITEM_HEIGHT,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED_CB			= 0,

		CTRL_BOKEH_L			= 1,
		CTRL_SMPL_CB			= 2,
		CTRL_BLUR1_TYPE_CB		= 3,
		CTRL_BLUR1_VALUE_SI		= 4,
		CTRL_BLUR2_TYPE_CB		= 5,
		CTRL_BLUR2_VALUE_SI		= 6,
		CTRL_BLUR_THRESHOLD_SF	= 7,

		CTRL_FOCUS_L			= 8,
		CTRL_POINT_SF			= 9,
		CTRL_RANGE_SF			= 10,
		CTRL_NEAR_SF			= 11,
		CTRL_FAR_SF				= 12,
	};

private:
	Mix::Scene::IRenderer* m_pSceneRenderer;
	Mix::Scene::ICamera* m_pCamera;

	Utility::UI::CheckBox m_EnabledCB;

	Utility::UI::Label m_BokehL;
	Utility::UI::ComboBox m_SmplCB;
	Utility::UI::ComboBox m_Blur1TypeCB;
	Utility::UI::SliderI m_Blur1ValueSI;
	Utility::UI::ComboBox m_Blur2TypeCB;
	Utility::UI::SliderI m_Blur2ValueSI;
	Utility::UI::SliderF m_BlurThresholdSF;

	Utility::UI::Label m_FocusL;
	Utility::UI::SliderF m_PointSF;
	Utility::UI::SliderF m_RangeSF;
	Utility::UI::SliderF m_NearSF;
	Utility::UI::SliderF m_FarSF;

	Mix::Scene::BLUR m_Blur1Table[Mix::Scene::BLUR::TYPE_MAX];
	Mix::Scene::BLUR m_Blur2Table[Mix::Scene::BLUR::TYPE_MAX];

	static const Int32 SMOOTH_RANGE_TABLE[Mix::Scene::BLUR::TYPE_MAX][2];

private:
	void UpdateFocus( void );

	static Int32 GetSmoothValue( const Mix::Scene::BLUR& blur );
	static void SetSmoothValue( Mix::Scene::BLUR& blur, Int32 value );

public:
	HUD( void );
	virtual ~HUD( void );

	void Open( Utility::UI::Manager* pManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

public:
	virtual void OnOpen( void );
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox );
};
