#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/HID.h"
#include "Mix/Graphics.h"
#include "Mix/Scene.h"

#include "Utility/Common.h"
#include "Utility/UniversalCameraHelper.h"

#include "hud.h"

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

static const Mix::Vector3 SUN_POS( 0.5f, 1.0f, -0.5f );

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_KEYBOARD | Mix::EC_MOUSE | Mix::EC_GRAPHICS | Mix::EC_SCENE;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"Scene\\PostEffect\\DepthOfField" );
	engineConfig.pCaption = L"Scene - PostEffect ( DepthOfField )";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pInputMgr = Mix::HID::GetManagerPtr();
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Scene::IManager* pSceneMgr = Mix::Scene::GetManagerPtr();

		Mix::HID::IMouse* pMouse = NULL;
		Mix::HID::IKeyboard* pKeyboard = NULL;

		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;

		Mix::Scene::IEffectPackage* pSceneEffectPackage = NULL;
		Mix::Scene::IRenderer* pSceneRenderer = NULL;
		Mix::Scene::IUniversalCamera* pCamera = NULL;

		Utility::UniversalCameraHelper camHelper;
		Utility::UI::Manager uiManager;
		HUD m_HUD;

		Mix::StringW tempStr;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pInputMgr->GetMouse( &pMouse );
		pInputMgr->GetKeyboard( &pKeyboard );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, L"Sample" ) == True )
		{
			Mix::Graphics::Utility::IFont* pFont_16_400 = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont_16_400 ) == True )
			{
				pCanvasRenderer->SetFont( pFont_16_400 );
			}

			MIX_RELEASE( pFont_16_400 );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( pSceneMgr->CreateEffectPackage( L"Data\\", L"effects", &pSceneEffectPackage ) == True )
		{
			Mix::Scene::RENDERER_CONFIG config;

			config.caps = Mix::Scene::RCAP_DEPTH_OF_FIELD | Mix::Scene::RCAP_SHADOW_MAPPING;

			if( pSceneMgr->CreateRenderer( pSceneEffectPackage, config, &pSceneRenderer, L"Sample" ) == True )
			{
				Mix::Scene::CAMERA_CONFIG camConfig;
				Mix::Scene::IDirectionalLight* pDirLight = NULL;
				Mix::Scene::ITerrainModel* pRoomModel = NULL;

				camConfig.caps = Mix::Scene::RCAP_DEPTH_OF_FIELD | Mix::Scene::RCAP_SHADOW_MAPPING;
				camConfig.targetSize.Set( SCREEN_WIDTH, SCREEN_HEIGHT );
				camConfig.colorTexFormat = Mix::Graphics::FMT_R8G8B8A8;
				camConfig.smDepthTexSize = 2048;
				camConfig.smSmplRes = Mix::Scene::RSMPL_DOWN2X;

				if( pSceneMgr->CreateUniversalCamera( camConfig, &pCamera ) == True )
				{
					Mix::Scene::ICamera::VISIBILITY_SETTINGS visiSettings = pCamera->GetVisiblitySettings();
					Mix::Scene::ICamera::DOF_SETTINGS dofSettings = pCamera->GetDofSettings();
					Mix::Scene::ICamera::SHADOW_MAPPING_SETTINGS smSettings = pCamera->GetShadowMappingSettings();

					pCamera->SetBackgroundColor( Mix::Vector4( 0.2f, 0.7f, 0.95f ) );
					pCamera->SetProjection( MIX_TO_RAD( 60.0f ), ( Float32 )SCREEN_WIDTH / ( Float32 )SCREEN_HEIGHT, 1.0f, 2000.0f );

					visiSettings.sdwLimitDistance = 200.0f;
					visiSettings.sdwFalloffAmount = 100.0f;
					pCamera->SetVisiblitySettings( visiSettings );

					smSettings.depthBias = -0.69997531f;
					pCamera->SetShadowMappingSettings( smSettings );

					dofSettings.nearZ = 10.0f;
					dofSettings.nearDist = 5.0f;
					dofSettings.farZ = 20.0f;
					dofSettings.farDist = 40.0f;
					pCamera->SetDofEnabled( True );
					pCamera->SetDofSettings( dofSettings );

					pCamera->SetShadowMappingEnabled( True );

					pSceneRenderer->AddCamera( pCamera );
				}

				if( pSceneMgr->CreateTerrainModelFromFile( pSceneEffectPackage, L"Data\\Model\\blocks.mtm", &pRoomModel ) == True )
				{
					pSceneRenderer->AddTerrainModel( pRoomModel );
					MIX_RELEASE( pRoomModel );
				}

				if( pSceneMgr->CreateDirectionalLight( &pDirLight ) == True )
				{
					pDirLight->SetEnabled( True );
					pDirLight->SetDirection( -SUN_POS.ToNormalize() );

					pSceneRenderer->SetDirectionalLight( pDirLight );

					MIX_RELEASE( pDirLight );
				}
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		Mix::Graphics::Utility::IFont* pFontUI = NULL;

		camHelper.Initialize(	pKeyboard,
								pMouse,
								Mix::Vector3( 0.0f, 2.0f, -99.0f ),
								Mix::Vector3( 0.0f, 2.0f, 0.0f ),
								0.2f );

		pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_12_200.fnt", &pFontUI );

		uiManager.Initialize( pMouse, pCanvasRenderer, pFontUI );
		m_HUD.Open( &uiManager, pSceneRenderer, pCamera );

		MIX_RELEASE( pFontUI );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pEngine->ResetFPS();

		while( pEngine->Update() == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// J
			////////////////////////////////////////////////////////////////////////////////////////////////////

			camHelper.Update();

			if( pCamera != NULL )
			{
				pCamera->SetView( camHelper.GetEye(), camHelper.GetAt(), camHelper.GetUp() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// LoX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCanvasRenderer != NULL )
			{
				tempStr.Sprintf(	L"FPS  [%f]\n"
									L"STPS [%f]\n"
									L"IF   [%d/%d]",	pEngine->GetFPS(),
														pEngine->GetSleepTimePerSec(),
														pEngine->GetInsomniaFrameCountPerSec(), pEngine->GetInsomniaFrameMax() );

				pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
				pCanvasRenderer->AddString(	16.0f, 16.0f, tempStr.GetConstPtr() );
				pCanvasRenderer->AddString(	16.0f, pGraphicsDev->GetScreenSize().y - 64.0f,
									L"Controls :\n"
									L"  Rotate camera : Mouse middle button\n"
									L"  Move camera   : W S A D key\n" );

				Utility::DrawMouseCursor( pCanvasRenderer, pMouse->GetPos() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCamera != NULL )
			{
				pCamera->Update();
			}

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Update( pEngine->GetDT() );
			}

			if( pCanvasRenderer != NULL )
			{
				uiManager.Update();

				Utility::DrawMouseCursor( pCanvasRenderer, pMouse->GetPos() );

				pCanvasRenderer->Update();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tbV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Refresh();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// `
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );

			if( pGraphicsDev->Begin() == True )
			{
				if( pCamera != NULL )
				{
					pCamera->Draw();
				}

				if( pCanvasRenderer != NULL )
				{
					pCanvasRenderer->Draw();
				}

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		uiManager.Dispose();
		camHelper.Dispose();

		MIX_RELEASE( pCamera );
		MIX_RELEASE( pSceneRenderer );
		MIX_RELEASE( pSceneEffectPackage );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pKeyboard );
		MIX_RELEASE( pMouse );

		Mix::Finalize();
	}

	return 0;
}
