#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Button.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Label.h"
#include "Utility/UI/Slider.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 230,
		DLG_HEIGHT		= 368,

		LABEL_X			= 0,
		LABEL_WIDTH		= 80,

		ITEM_X			= 80,
		ITEM_WIDTH		= 128,
		ITEM_HEIGHT		= 20,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_LUM_L					= 0,
		CTRL_LUM_TONE_MAPPING_CB	= 1,
		CTRL_LUM_BLUE_SHIFT_CB		= 2,
		CTRL_LUM_WHITE_SF			= 3,
		CTRL_LUM_RODS_SF			= 4,
		CTRL_LUM_CONES_SF			= 5,
		CTRL_LUM_FORCE_ADAPTATION	= 6,
		CTRL_LUM_SR_ADAPTATION		= 7,

		CTRL_BLOOM_L				= 8,
		CTRL_BLOOM_ENABLED_CB		= 9,
		CTRL_BLOOM_WHITE_SF			= 10,
		CTRL_BLOOM_OFFSET_SF		= 11,
		CTRL_BLOOM_THRESHOLD_SF		= 12,
		CTRL_BLOOM_SCALE_SF			= 13,

		CTRL_DOF_L					= 14,
		CTRL_DOF_ENABLED_CB			= 15,
	};

private:
	Mix::Scene::ICamera* m_pCamera;

	Utility::UI::Label m_LumL;
	Utility::UI::CheckBox m_LumToneMappingCB;
	Utility::UI::CheckBox m_LumBlueShiftCB;
	Utility::UI::SliderF m_LumWhiteSF;
	Utility::UI::SliderF m_LumRodsSF;
	Utility::UI::SliderF m_LumConesSF;
	Utility::UI::Button m_LumForceAdaptationB;
	Utility::UI::Button m_LumSRAdaptationB;

	Utility::UI::Label m_BloomL;
	Utility::UI::CheckBox m_BloomEnabledCB;
	Utility::UI::SliderF m_BloomWhiteSF;
	Utility::UI::SliderF m_BloomOffsetSF;
	Utility::UI::SliderF m_BloomThresholdSF;
	Utility::UI::SliderF m_BloomScaleSF;

	Utility::UI::Label m_DofL;
	Utility::UI::CheckBox m_DofEnabledCB;

public:
	HUD( void );
	virtual ~HUD( void );

public:
	void Initialize( Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnDispose( void );
	virtual void OnButton_Click( Utility::UI::Button* pButton );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
};
