#pragma once

#include "Utility/UI/Dialog.h"
#include "Utility/UI/Button.h"
#include "Utility/UI/CheckBox.h"
#include "Utility/UI/Label.h"
#include "Utility/UI/Slider.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 230,
		DLG_HEIGHT		= 432,

		LABEL_X			= 0,
		LABEL_WIDTH		= 80,

		ITEM_X			= 80,
		ITEM_WIDTH		= 128,
		ITEM_HEIGHT		= 20,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_BP_L				= 0,
		CTRL_BP_WHITE_SF		= 1,
		CTRL_BP_THRESHOLD_SF	= 2,
		CTRL_BP_OFFSET_SF		= 3,

		CTRL_GHOST_L			= 4,
		CTRL_GHOST_NUM_SI		= 5,
		CTRL_GHOST_WEIGHT_SF	= 6,
		CTRL_GHOST_DISPERSAL_SF	= 7,

		CTRL_HALO_L				= 8,
		CTRL_HALO_WEIGHT_SF		= 9,
		CTRL_HALO_WIDTH_SF		= 10,

		CTRL_BRUST_L			= 11,
		CTRL_BRUST_SHARPNESS_SF	= 12,
		CTRL_BRUST_INTENSITY_SF	= 13,

		CTRL_DIRT_L				= 14,
		CTRL_DIRT_SHARPNESS_SF	= 15,
		CTRL_DIRT_INTENSITY_SF	= 16,

		CTRL_MISC_L				= 17,
		CTRL_DISTORTION_SF		= 18,
		CTRL_BLUR_SI			= 19,
		CTRL_INTENSITY_SF		= 20,
	};

private:
	Mix::Scene::ICamera* m_pCamera;

	Utility::UI::Label m_BPL;
	Utility::UI::SliderF m_BPWhiteSF;
	Utility::UI::SliderF m_BPThresholdSF;
	Utility::UI::SliderF m_BPOffsetSF;

	Utility::UI::Label m_GhostL;
	Utility::UI::SliderI m_GhostNumSI;
	Utility::UI::SliderF m_GhostWeightSF;
	Utility::UI::SliderF m_GhostDispersalSF;

	Utility::UI::Label m_HaloL;
	Utility::UI::SliderF m_HaloWeightSF;
	Utility::UI::SliderF m_HaloWidthSF;

	Utility::UI::CheckBox m_BrustL;
	Utility::UI::SliderF m_BrustSharpnessSF;
	Utility::UI::SliderF m_BrustIntensitySF;

	Utility::UI::CheckBox m_DirtL;
	Utility::UI::SliderF m_DirtSharpnessSF;
	Utility::UI::SliderF m_DirtIntensitySF;

	Utility::UI::Label m_MiscL;
	Utility::UI::SliderF m_DistortionSF;
	Utility::UI::SliderI m_BlurSI;
	Utility::UI::SliderF m_IntensitySF;

	Mix::Graphics::ITexture* m_pBrustTex;
	Mix::Graphics::ITexture* m_pDirtTex;

public:
	HUD( void );
	virtual ~HUD( void );

public:
	void Initialize( Mix::Scene::ICamera* pCamera );

protected:
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
};
