#include "stdafx.h"

#include "Mix/IO.h"
#include "Mix/HID.h"
#include "Mix/Graphics.h"
#include "Mix/Scene.h"

#include "Utility/Common.h"
#include "Utility/UniversalCameraHelper.h"

#ifdef _DEBUG
	#include <crtdbg.h>
#endif //_DEBUG

#define SCREEN_WIDTH 1024
#define SCREEN_HEIGHT 768

static const Mix::Vector3 SUN_POS( -0.04f, 1.0f, 0.06f );

int APIENTRY _tWinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow )
{
#ifdef _DEBUG
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif //_DEBUG

	Mix::ENGINE_CONFIG engineConfig;

	engineConfig.flags = Mix::EC_IO_NARROW | Mix::EC_KEYBOARD | Mix::EC_MOUSE | Mix::EC_GRAPHICS | Mix::EC_SCENE;
	engineConfig.pRootDirectoryPath = Utility::GetRootDirectoryPath();
	engineConfig.pPluginDirectoryPath = Utility::GetPluginsDirectoryPath();
	engineConfig.pUserDirectoryPath = Utility::GetUserDirectoryPath( L"Scene\\PostEffect\\LightShafts" );
	engineConfig.pCaption = L"Scene - PostEffect ( LightShafts )";
	engineConfig.targetSize = Mix::Point( SCREEN_WIDTH, SCREEN_HEIGHT );
	engineConfig.shaderModel = Mix::Graphics::SHADER_MODEL_3;

	if( Mix::Initialize( engineConfig ) == True )
	{
		Mix::IEngine* pEngine = Mix::GetEnginePtr();

		Mix::IO::IManager* pIOMgr = Mix::IO::GetManagerPtr();
		Mix::HID::IManager* pInputMgr = Mix::HID::GetManagerPtr();
		Mix::Graphics::IManager* pGraphicsMgr = Mix::Graphics::GetManagerPtr();
		Mix::Scene::IManager* pSceneMgr = Mix::Scene::GetManagerPtr();

		Mix::HID::IMouse* pMouse = NULL;
		Mix::HID::IKeyboard* pKeyboard = NULL;

		Mix::Graphics::IDevice* pGraphicsDev = NULL;
		Mix::Graphics::Utility::ICanvasRenderer* pCanvasRenderer = NULL;

		Mix::Scene::IEffectPackage* pSceneEffectPackage = NULL;
		Mix::Scene::IRenderer* pSceneRenderer = NULL;
		Mix::Scene::IUniversalCamera* pCamera = NULL;

		Utility::UniversalCameraHelper camHelper;

		Mix::StringW tempStr;

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pIOMgr->MountDirectory( L"Data" );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pInputMgr->GetMouse( &pMouse );
		pInputMgr->GetKeyboard( &pKeyboard );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pGraphicsMgr->GetDevice( &pGraphicsDev );

		if( pGraphicsMgr->CreateCanvasRenderer( &pCanvasRenderer, L"Sample" ) == True )
		{
			Mix::Graphics::Utility::IFont* pFont_16_400 = NULL;

			if( pGraphicsMgr->CreateFontFromFile( L"Data\\Font\\mspg_16_400.fnt", &pFont_16_400 ) == True )
			{
				pCanvasRenderer->SetFont( pFont_16_400 );
			}

			MIX_RELEASE( pFont_16_400 );
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		if( pSceneMgr->CreateEffectPackage( L"Data\\", L"effects", &pSceneEffectPackage ) == True )
		{
			Mix::Scene::RENDERER_CONFIG config;

			config.caps = Mix::Scene::RCAP_ATMOSPHERE | Mix::Scene::RCAP_LUMINOSITY | Mix::Scene::RCAP_SHADOW_MAPPING | Mix::Scene::RCAP_LIGHT_SHAFTS;

			if( pSceneMgr->CreateRenderer( pSceneEffectPackage, config, &pSceneRenderer, L"Sample" ) == True )
			{
				Mix::Scene::CAMERA_CONFIG camConfig;
				Mix::Scene::ISkyDome* pSkyDome = NULL;
				Mix::Scene::IDirectionalLight* pDirLight = NULL;
				Mix::Scene::IAtmosphereScatter* pAtmosphereScatter = NULL;
				Mix::Scene::ILightShaftsCaster* pLightShaftsCaster = NULL;

				Mix::Scene::ITerrainModel* pRoomModel = NULL;

				////////////////////////////////////////////////////////////////////////////////////////////////////

				if( pSceneMgr->CreateSkyDome(	1000.0f,
												150.0f,
												Mix::Scene::ISkyDome::QL_MIDDLE,
												Mix::Scene::ISkyDome::QL_MIDDLE,
												&pSkyDome,
												MIX_DEBUGNAME ) == True )
				{
					pSceneRenderer->SetSkyDome( pSkyDome );
				}

				pSkyDome->SetSunPosition( SUN_POS );

				////////////////////////////////////////////////////////////////////////////////////////////////////

				pSceneRenderer->GetAtmosphereScatter( &pAtmosphereScatter );

				if( pSceneMgr->CreateDirectionalLight( &pDirLight ) == True )
				{
					pDirLight->SetEnabled( True );
					pDirLight->SetDirection( pSkyDome->GetSunLight().dir );
					pDirLight->SetColor( pAtmosphereScatter->GetSunLightColor() );

					pSceneRenderer->SetDirectionalLight( pDirLight );
				}

				if( pSceneMgr->CreateLightShaftsCaster( &pLightShaftsCaster, MIX_DEBUGNAME ) == True )
				{
					pLightShaftsCaster->SetPosition( pSkyDome->GetSunLight().pos );
					pSceneRenderer->SetLightShaftsCaster( pLightShaftsCaster );
				}

				////////////////////////////////////////////////////////////////////////////////////////////////////

				camConfig.targetSize.Set( SCREEN_WIDTH, SCREEN_HEIGHT );
				camConfig.caps = Mix::Scene::RCAP_ATMOSPHERE | Mix::Scene::RCAP_LUMINOSITY | Mix::Scene::RCAP_SHADOW_MAPPING | Mix::Scene::RCAP_LIGHT_SHAFTS;
				camConfig.colorTexFormat = Mix::Graphics::FMT_R16G16B16A16F;
//				camConfig.colorTexFormat = Mix::Graphics::FMT_R32G32B32A32F;

				if( pSceneMgr->CreateUniversalCamera( camConfig, &pCamera ) == True )
				{
					Mix::Scene::ICamera::LUMINOSITY_SETTINGS lumSettings = pCamera->GetLuminositySettings();
					Mix::Scene::ICamera::LIGHT_SHAFTS_SETTINGS lsSettings = pCamera->GetLightShaftsSettings();

					pCamera->SetBackgroundColor( Mix::Vector4( 0.2f, 0.2f, 0.2f, 1.0f ) );
					pCamera->SetProjection( MIX_TO_RAD( 60.0f ), 0.01f, 2000.0f );

					pCamera->SetShadowMappingEnabled( True );

					lumSettings.flags = Mix::Scene::ICamera::LUM_TONE_MAPPING;
					pCamera->SetLuminositySettings( lumSettings );

					lsSettings.samples = Mix::Scene::ICamera::LS_128;
					lsSettings.density = 0.9f;
					lsSettings.decay = 0.96f;
					pCamera->SetLightShaftsSettings( lsSettings );
					pCamera->SetLightShaftsEnabled( True );

					pSceneRenderer->AddCamera( pCamera );
				}

				if( pSceneMgr->CreateTerrainModelFromFile( pSceneEffectPackage, L"Data\\Model\\cave.mtm", &pRoomModel ) == True )
				{
					pSceneRenderer->AddTerrainModel( pRoomModel );
					MIX_RELEASE( pRoomModel );
				}

				////////////////////////////////////////////////////////////////////////////////////////////////////

				MIX_RELEASE( pLightShaftsCaster );
				MIX_RELEASE( pAtmosphereScatter );
				MIX_RELEASE( pSkyDome );
				MIX_RELEASE( pDirLight );
			}
		}

		////////////////////////////////////////////////////////////////////////////////////////////////////

		camHelper.Initialize(	pKeyboard,
								pMouse,
								Mix::Vector3( -0.5f, 1.0f, -8.0f ),
								Mix::Vector3( -0.5f, 1.0f, 0.0f ),
								0.05f );

		////////////////////////////////////////////////////////////////////////////////////////////////////

		pEngine->ResetFPS();

		while( pEngine->Update() == True )
		{
			////////////////////////////////////////////////////////////////////////////////////////////////////
			// J
			////////////////////////////////////////////////////////////////////////////////////////////////////

			camHelper.Update();

			if( pCamera != NULL )
			{
				pCamera->SetView( camHelper.GetEye(), camHelper.GetAt(), camHelper.GetUp() );
			}

#if 0
			Mix::Scene::IAtmospherePreference* pASSys = NULL;
			Mix::Scene::IAtmospherePreference::VOLUMETRIC_LIGHTING_PARAM vlParam;
			pSceneRenderer->GetAtmospherePreference( &pASSys );
			vlParam = pASSys->GetVolumetricLightingParam();

			if( pKeyboard->GetKeyState( Mix::HID::KEY_Z ) & Mix::HID::DOWN )
			{
				vlParam.decay = MIX_CLAMP( vlParam.decay - 0.01f, 0.0f, 1.0f );
			}
			else if( pKeyboard->GetKeyState( Mix::HID::KEY_X ) & Mix::HID::DOWN )
			{
				vlParam.decay = MIX_CLAMP( vlParam.decay + 0.01f, 0.0f, 1.0f );
			}

			if( pKeyboard->GetKeyState( Mix::HID::KEY_C ) & Mix::HID::DOWN )
			{
				vlParam.density = MIX_CLAMP( vlParam.density - 0.01f, 0.0f, 1.0f );
			}
			else if( pKeyboard->GetKeyState( Mix::HID::KEY_V ) & Mix::HID::DOWN )
			{
				vlParam.density = MIX_CLAMP( vlParam.density + 0.01f, 0.0f, 1.0f );
			}

			if( pKeyboard->GetKeyState( Mix::HID::KEY_B ) & Mix::HID::DOWN )
			{
				vlParam.weight = MIX_CLAMP( vlParam.weight - 0.01f, 0.0f, 1.0f );
			}
			else if( pKeyboard->GetKeyState( Mix::HID::KEY_N ) & Mix::HID::DOWN )
			{
				vlParam.weight = MIX_CLAMP( vlParam.weight + 0.01f, 0.0f, 1.0f );
			}

			pASSys->SetVolumetricLightingParam( vlParam );
			MIX_RELEASE( pASSys );
#endif

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// LoX
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCanvasRenderer != NULL )
			{
				tempStr.Sprintf(	L"FPS  [%f]\n"
									L"STPS [%f]\n"
									L"IF   [%d/%d]",	pEngine->GetFPS(),
														pEngine->GetSleepTimePerSec(),
														pEngine->GetInsomniaFrameCountPerSec(), pEngine->GetInsomniaFrameMax() );

				pCanvasRenderer->SetColor( Mix::Vector4( 1.0f, 1.0f, 1.0f, 1.0f ) );
				pCanvasRenderer->AddString(	16.0f, 16.0f, tempStr.GetConstPtr() );
				pCanvasRenderer->AddString(	16.0f, pGraphicsDev->GetScreenSize().y - 64.0f,
									L"Controls :\n"
									L"  Rotate camera : Mouse middle button\n"
									L"  Move camera   : W S A D key\n" );

				Utility::DrawMouseCursor( pCanvasRenderer, pMouse->GetPos() );
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// XV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pCamera != NULL )
			{
				pCamera->Update();
			}

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Update( pEngine->GetDT() );
			}

			if( pCanvasRenderer != NULL )
			{
				pCanvasRenderer->Update();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// tbV
			////////////////////////////////////////////////////////////////////////////////////////////////////

			if( pSceneRenderer != NULL )
			{
				pSceneRenderer->Refresh();
			}

			////////////////////////////////////////////////////////////////////////////////////////////////////
			// `
			////////////////////////////////////////////////////////////////////////////////////////////////////

			pGraphicsDev->SetViewBounds( 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT );

			if( pGraphicsDev->Begin() == True )
			{
				if( pCamera != NULL )
				{
					pCamera->Draw();
				}

				if( pCanvasRenderer != NULL )
				{
					pCanvasRenderer->Draw();
				}

				pGraphicsDev->End();
			}

			pGraphicsDev->Present();
		}

		camHelper.Dispose();

		MIX_RELEASE( pCamera );
		MIX_RELEASE( pSceneRenderer );
		MIX_RELEASE( pSceneEffectPackage );
		MIX_RELEASE( pCanvasRenderer );
		MIX_RELEASE( pGraphicsDev );
		MIX_RELEASE( pKeyboard );
		MIX_RELEASE( pMouse );

		Mix::Finalize();
	}

	return 0;
}
