#pragma once

#include "Utility/UI.h"

class HUD : public Utility::UI::Dialog
{
private:
	enum VALUE
	{
		DLG_WIDTH		= 238,
		DLG_HEIGHT		= 336,

		LABEL_WIDTH		= 80,

		ITEM_X			= 88,
		ITEM_WIDTH		= 128,
		ITEM_HEIGHT		= 20,

		ITEM_X1			= ITEM_X,
		ITEM_WIDTH1		= ITEM_WIDTH / 8 * 5 - 1,
		ITEM_HEIGHT1	= ITEM_HEIGHT,

		ITEM_X2			= ITEM_X1 + ITEM_WIDTH1 + 2,
		ITEM_WIDTH2		= ITEM_WIDTH / 8 * 3 - 1,
		ITEM_HEIGHT2	= ITEM_HEIGHT,

		ITEM_Y_STEP		= 24,
		ITEM_YY_STEP	= 32,
	};

	enum CTRL_ID
	{
		CTRL_ENABLED			= 0,

		CTRL_TARGET_L			= 1,
		CTRL_TARGET_FORMAT_CB	= 2,
		CTRL_TARGET_SIZE_CB	= 3,

		CTRL_Z_L				= 4,
		CTRL_ZBIAS_SF			= 5,
		CTRL_ZSLOPE_SF			= 6,
		CTRL_ZCLAMP_SF			= 7,

		CTRL_SMOOTH_L			= 8,
		CTRL_PCF_CB				= 9,
		CTRL_SMPL_CB			= 10,
		CTRL_BLUR_CB			= 11,
		CTRL_BLUR_SI			= 12,

		CTRL_MISC_L				= 13,
		CTRL_DISTANCE_SF		= 14,
		CTRL_TINT_SF			= 15,

#ifdef _DEBUG
		CTRL_DEBUG_CB			= 16,
#endif //_DEBUG
	};

private:
	Mix::Scene::IRenderer* m_pSceneRenderer;
	Mix::Scene::ICamera* m_pCamera;

	Utility::UI::CheckBox m_EnabledCB;

	Utility::UI::Label m_TargetL;
	Utility::UI::ComboBox m_TargetFormatCB;
	Utility::UI::ComboBox m_TargetSizeCB;

	Utility::UI::Label m_SmoothL;
	Utility::UI::ComboBox m_PcfCB;
	Utility::UI::ComboBox m_SmplCB;
	Utility::UI::ComboBox m_BlurCB;
	Utility::UI::SliderI m_BlurSI;

	Utility::UI::Label m_DepthL;
	Utility::UI::SliderF m_DepthBiasSF;
	Utility::UI::SliderF m_DepthSlopeSF;
	Utility::UI::SliderF m_DepthClampSF;
#ifdef _DEBUG
	Utility::UI::CheckBox m_DebugCB;
#endif //_DEBUG

	Utility::UI::Label m_MiscL;
	Utility::UI::SliderF m_DistSF;
	Utility::UI::SliderF m_TintSF;

	Mix::Scene::BLUR m_ProjSmoothTable[Mix::Scene::BLUR::TYPE_MAX];

	static const Int32 SMOOTH_RANGE_TABLE[Mix::Scene::BLUR::TYPE_MAX][2];

public:
	HUD( void );
	virtual ~HUD( void );

	void Open( Utility::UI::Manager* pManager, Mix::Scene::IRenderer* pSceneRenderer, Mix::Scene::ICamera* pCamera );

	static Int32 GetSmoothValue( const Mix::Scene::BLUR& blur );
	static void SetSmoothValue( Mix::Scene::BLUR& blur, Int32 value );

public:
	virtual void OnOpen( void );
	virtual void OnDispose( void );
	virtual void OnCheckBox_Click( Utility::UI::CheckBox* pCheckBox );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderI* pSlider );
	virtual void OnSlider_ValueChanged( Utility::UI::SliderF* pSlider );
	virtual void OnComboBox_SelectItemChanged( Utility::UI::ComboBox* pComboBox );
};
