#pragma once

//! @file Utility/FollowCameraHelper.h
//! @brief Ǐ]Jwp[NXCN[ht@C

namespace Utility {

	//! @class FollowCameraHelper
	//! @brief Ǐ]Jwp[NX
	class FollowCameraHelper
	{
	private:
		Mix::Quaternion m_TargetRot;
		Mix::Vector3 m_TargetPos;

		Float32 m_RotCoiffe;
		Float32 m_PosCoiffe;
		Float32 m_EyeCoiffe;

		Float32 m_Dist;
		Float32 m_Elev;

		Mix::Vector3 m_EyeVec;
		Mix::Vector3 m_Eye;
		Mix::Vector3 m_At;
		Mix::Vector3 m_Up;

	public:
		//! @brief RXgN^
		FollowCameraHelper( void );
		//! @brief fXgN^
		~FollowCameraHelper( void );

	public:
		//! @brief ܂
		//! @param[in] targetRot ^[Qbg̉]
		//! @param[in] targetPos ^[Qbg̈ʒu
		//! @param[in] dist ^[Qbg王_܂ł̋
		//! @param[in] elevation p( WAP )
		//! @param[in] up 
		void Initialize(	const Mix::Quaternion& targetRot,
							const Mix::Vector3& targetPos,
							Float32 dist,
							Float32 elevation,
							const Mix::Vector3& up = Mix::Vector3( 0.0f, 1.0f, 0.0f ) );

		//! @brief ]̕Ԓl擾܂
		//! @return ԒlԂ܂
		Float32 GetRotCoiffe( void ) const;
		//! @brief ]̕Ԓlݒ肵܂
		//! @param[in] coiffe Ԓl
		void SetRotCoiffe( Float32 coiffe );

		//! @brief ʒu̕Ԓl擾܂
		//! @return ԒlԂ܂
		Float32 GetPosCoiffe( void ) const;
		//! @brief ʒu̕Ԓlݒ肵܂
		//! @param[in] coiffe Ԓl
		void SetPosCoiffe( Float32 coiffe );

		//! @brief _̕Ԓl擾܂
		//! @return ԒlԂ܂
		Float32 GetEyeCoiffe( void ) const;
		//! @brief _̕Ԓlݒ肵܂
		//! @param[in] coiffe Ԓl
		void SetEyeCoiffe( Float32 coiffe );

		//! @brief ^[Qbg王_܂ł̋擾܂
		//! @return Ԃ܂
		Float32 GetDistance( void ) const;
		//! @brief ^[Qbg王_܂ł̋ݒ肵܂
		//! @param[in] dist 
		void SetDistance( Float32 dist );

		//! @brief p擾܂
		//! @return pԂ܂
		Float32 GetElevation( void ) const;
		//! @brief pݒ肵܂
		//! @param[in] elevation p( WAP )
		void SetElevation( Float32 elevation );

		//! @brief XV܂
		//! @param[in] targetRot ^[Qbg̉]
		//! @param[in] targetPos ^[Qbg̈ʒu
		void Update( const Mix::Quaternion& targetRot, const Mix::Vector3& targetPos );

		//! @brief _擾܂
		//! @return _Ԃ܂
		const Mix::Vector3& GetEye( void ) const;
		//! @brief _擾܂
		//! @return _Ԃ܂
		const Mix::Vector3& GetAt( void ) const;
		//! @brief 擾܂
		//! @return Ԃ܂
		const Mix::Vector3& GetUp( void ) const;
	};
}
