#pragma once

//! @file Utility/Motion/StateMachine.h
//! @brief Xe[g}VNXCN[ht@C

#include <vector>
#include <map>

#include "Mix/Common.h"
#include "Mix/Scene.h"

namespace Utility{ namespace Motion{

	//! @class StateMachine
	//! @brief Xe[g}VNX
	class StateMachine
	{
	public:
		class Channel;

		//! @enum CONSTANT
		//! @brief 萔
		enum CONSTANT
		{
			MAX_CHANNEL	= 32,	//!< ő`l
		};

		//! @struct TRANSITION_DESC
		//! @brief  gWV\
		struct TRANSITION_DESC
		{
			UInt32 state;		//!< Xe[g
			Boolean bForce;		//!< Iɐ؂ւ
			Float32 timeLength;	//!< ؂ւɂ鎞Ԃ̒( bP )
		};

		//! @struct STATE_DESC
		//! @brief Xe[g\
		struct STATE_DESC
		{
			UInt32 channelMask;					//!< `l}XN
			const wchar_t* pMotionName;			//!< [V
			UInt32 loopCount;					//!< [v( Mix::Scene::MOTION_INFINITE_LOOP Ŗ[v )
			const TRANSITION_DESC* transitions;	//!< gWVz
			UInt32 transitionCount;				//!< gWVz̗vf
			Boolean bInherit;					//!< [VĐۂɃ[vAgWV󂯌pꍇ True
		};

		//! @class Task
		//! @brief ^XNNX
		class Task
		{
		public:
			//! @brief fXgN^
			virtual ~Task( void ) {}

		public:
			//! @brief ^XNJnۂɌĂяo܂
			virtual void OnBegin( void ) {}
			//! @brief ^XNXVۂɌĂяo܂
			//! @param[in] dt f^^C
			virtual void OnUpdate( Float32 dt ) {}
			//! @brief ^XNIۂɌĂяo܂
			virtual void OnEnd( void ) {}
		};

		//! @class State
		//! @brief Xe[gNX
		class State
		{
		private:
			typedef std::vector<StateMachine::TRANSITION_DESC> TransitionList;
			typedef std::map<UInt32, const StateMachine::TRANSITION_DESC*> TransitionPtrMap;

		private:
			UInt32 m_ID;
			UInt32 m_ChannelMask;
			Boolean m_bInherit;

			Mix::Scene::MOTION_HANDLE m_MotionHandle;
			Mix::Scene::IMotion* m_pMotion;
			Mix::Scene::IMotionState* m_pMotionState;
			UInt32 m_MotionLoopCount;

			State::TransitionList m_TransitionList;
			State::TransitionPtrMap m_TransitionPtrMap;

			Boolean m_bActive;

			StateMachine::Task* m_pTask;

		private:
			State( UInt32 id, UInt32 channelMask, Boolean bInherit );
			~State( void );

			void SetMotion( const Mix::Scene::MOTION_HANDLE& handle,
							Mix::Scene::IMotion* pInterface,
							Mix::Scene::IMotionState* pState,
							UInt32 loopCount );

			void SetTransition( const StateMachine::TRANSITION_DESC* descs, UInt32 count );
			void SetActive( Boolean state );

			friend class Channel;

		public:
			//! @brief ^XÑ|C^ݒ肵܂
			//! @param[in] pTask ^XN\ StateMachine::Task NX̃|C^
			void SetTaskPtr( StateMachine::Task* pTask );
			//! @brief ^XÑ|C^擾܂
			//! @return ^XN\ StateMachine::Task NX̃|C^Ԃ܂
			StateMachine::Task* GetTaskPtr( void );

			//! @brief ID擾܂
			//! @return IDԂ܂
			UInt32 GetID( void ) const;
			//! @brief `l}XN擾܂
			//! @return `l}XNԂ܂
			UInt32 GetChannelMask( void ) const;

			//! @brief [VĐ悤ƂۂɃ[vAgWV󂯌pǂmF܂
			//! @return 󂯌pꍇ True Ԃ܂
			Boolean IsInherit( void ) const;

			//! @brief [Vnh擾܂
			//! @return [Vnh\ Mix::Scene::MOTION_HANDLE \̂Ԃ܂
			const Mix::Scene::MOTION_HANDLE& GetMotionHandle( void ) const;
			//! @brief [Ṽ|C^擾܂
			//! @return Mix::Scene::IMotion C^[tF[X̃|C^Ԃ܂
			Mix::Scene::IMotion* GetMotionPtr( void ) const;
			//! @brief [VXe[g̃|C^擾܂
			//! @return Mix::Scene::IMotionState C^[tF[X̃|C^Ԃ܂
			Mix::Scene::IMotionState* GetMotionStatePtr( void ) const;
			//! @brief [Ṽ[v擾܂
			//! @return [Ṽ[vԂ܂
			UInt32 GetMotionLoopCount( void ) const;

			//! @brief gWV̐擾܂
			//! @return gWV̐Ԃ܂
			UInt32 GetTransitionCount( void ) const;
			//! @brief gWṼ|C^擾܂
			//! @param[in] index CfbNX
			//! @return gWV\ StateMachine::TRANSITION_DESC \̂̃|C^Ԃ܂
			const TRANSITION_DESC* GetTransitionPtrByIndex( UInt32 index ) const;
			//! @brief gWṼ|C^擾܂
			//! @param[in] state Xe[gID
			//! @return gWV\ StateMachine::TRANSITION_DESC \̂̃|C^Ԃ܂
			const TRANSITION_DESC* GetTransitionPtrByState( UInt32 state ) const;

			//! @brief Xe[gANeBuǂ擾܂
			//! @return Xe[gANeBuȏꍇ True Ԃ܂
			Boolean IsActive( void ) const;
		};

		//! @class Channel
		//! @brief `lNX
		class Channel
		{
		private:
			typedef std::map<UInt32, StateMachine::State*> StatePtrMap;

		private:
			StateMachine* m_pSubject;
			UInt32 m_ID;
			Mix::Scene::IMotionController* m_pMotionController;
			Channel::StatePtrMap m_StatePtrMap;
			StateMachine::State* m_pActiveState;
			Boolean m_bEnabled;

		private:
			Channel( StateMachine* pSubject, UInt32 id, Mix::Scene::IMotionController* pMotionController );
			~Channel( void );

			void SetEnabled( Boolean state );
			void Update( Float32 dt );

			friend class StateMachine;

		public:
			//! @brief `lID擾܂
			//! @return `lIDԂ܂
			UInt32 GetID( void ) const;

			//! @brief Xe[gǉ܂
			//! @param[in] id Xe[gID( 0xFFFFFFFF ȊO )
			//! @param[in] desc Xe[g̐\ StateMachine::STATE_DESC \
			//! @return Xe[g\ StateMachine::State NX̃|C^Ԃ܂
			StateMachine::State* AddState( UInt32 id, const StateMachine::STATE_DESC& desc );
			//! @brief Xe[g̃|C^擾܂
			//! @param[in] id Xe[gID( 0xFFFFFFFF ȊO )
			//! @return Xe[g\ StateMachine::State NX̃|C^Ԃ܂
			const StateMachine::State* GetStatePtr( UInt32 id ) const;

			//! @brief Xe[gύX܂
			//! @param[in] id ύXXe[gID( 0xFFFFFFFF ȊO )
			void ChangeState( UInt32 id );

			//! @brief ANeBuȃXe[gID擾܂
			//! @return ANeBuȃXe[gIDԂ܂
			//! @note ANeBuȃXe[g݂Ȃꍇ 0xFFFFFFFF Ԃ܂
			UInt32 GetActiveStateID( void ) const;
			//! @brief ANeBuȃXe[g̃|C^擾܂
			//! @return Xe[g\ StateMachine::State NX̃|C^Ԃ܂
			const StateMachine::State* GetActiveStatePtr( void ) const;

			//! @brief [VRg[[̃|C^擾܂
			//! @return [VRg[[\ Mix::Scene::IMotionController C^[tF[X̃|C^Ԃ܂
			Mix::Scene::IMotionController* GetMotionControllerPtr( void ) const;

			//! @brief `lLǂ擾܂
			//! @return `lLȏꍇ True Ԃ܂
			//! @note `l}XÑrbg( 1 << m_ID )LłȂꍇ False Ԃ܂
			Boolean IsEnabled( void ) const;
		};

	private:
		typedef std::vector<StateMachine::Channel*> ChannelPtrList;

	private:
		StateMachine::ChannelPtrList m_ChannelPtrList;
		UInt32 m_ChannelMask;

	private:
		void ChangeState( StateMachine::Channel* pActiveChannel, Boolean bForce, Float32 timeLength );

		friend class Channel;

	public:
		//! @brief RXgN^
		StateMachine( void );
		//! @brief fXgN^
		~StateMachine( void );

		//! @brief `lǉ܂
		//! @param[in] id `lID( 0`31 )
		//! @param[in] pMotionController [VRg[[\ Mix::Scene::IMotionController C^[tF[X̃|C^
		//! @return `l\ StateMachine::Channel NX̃|C^Ԃ܂
		//! @note ꍇ [VRg[[̎QƃJE^ +1 ܂
		StateMachine::Channel* AddChannel( UInt32 id, Mix::Scene::IMotionController* pMotionController );
		//! @brief `l擾܂
		//! @param[in] id `lID( 0`31 )
		//! @return `l\ StateMachine::Channel NX̃|C^Ԃ܂
		StateMachine::Channel* GetChannel( UInt32 id ) const;

		//! @brief Xe[g}VXV܂
		//! @param[in] dt f^^C
		void Update( Float32 dt );
	};
}}
