#pragma once

//! @file Utility/PlayableCamera.h
//! @brief vCAuJNXCN[ht@C

#include "Utility/Actor.h"

namespace Utility {

	//! @class PlayableCamera
	//! @brief vCAuJNX
	class PlayableCamera : public Utility::Actor
	{
	private:
		static const Mix::Vector3 UP;

		static const Float32 DEF_DISTANCE;
		static const Float32 MIN_DISTANCE;
		static const Float32 MAX_DISTANCE;
		static const Float32 STEP_DISTANCE;

	private:
		Mix::Scene::IUniversalCamera* m_pCamera;
		Mix::Scene::IActorNode* m_pNode;
		Mix::HID::IGamepad* m_pGamepad;

		Mix::Vector3 m_AtToEye;
		Float32 m_Height;
		Float32 m_Distance;

	private:
		Mix::Vector3 ComputeEye( void ) const;
		Mix::Vector3 ComputeAt( void ) const;

	public:
		//! @brief RXgN^
		//! @param[in] pCamera J\ Mix::Scene::IUniversalCamera C^[tF[X̃|C^
		//! @param[in] pGamepad Q[pbh\ Mix::HID::IGamepad C^[tF[X̃|C^
		//! @param[in] pModel f\ Mix::Scene::IActorModel C^[tF[X̃|C^
		PlayableCamera( Mix::Scene::IUniversalCamera* pCamera,
						Mix::HID::IGamepad* pGamepad,
						Mix::Scene::IActorModel* pModel );

		//! @brief fXgN^
		virtual ~PlayableCamera( void );

		//! @brief \[X܂
		void Dispose( void );

	public:
		//! @brief XV܂
		//! @param[in] dt f^^C
		virtual void OnUpdate( Float32 dt );
		//! @brief tbV܂
		virtual Boolean OnRefresh( void );
	};
}
