#pragma once

//! @file Utility/PlayableCharacter.h
//! @brief vCAuLN^[NXCN[ht@C

#include <vector>

#include "Utility/Actor.h"
#include "Utility/Motion/StateMachine.h"

namespace Utility{

	//! @class PlayableCharacter
	//! @brief vCAuLN^[NX
	class PlayableCharacter : public Utility::Character
	{
	public:
		//! @enum ACTION_TYPE
		//! @brief ANV^Cv񋓒萔
		enum ACTION_TYPE
		{
			ACTION_DAMAGE = 0,	//!< _[W
		};

	private:
		enum CHANNEL_ID
		{
			CHANNEL_BODY	= 0,
			CHANNEL_UPPER	= 1,
			CHANNEL_ARML	= 2,
			CHANNEL_ARMR	= 3,

			CHANNEL_ID_MAX	= 4,
		};

		enum STATE_ID
		{
			STATE_BODY_STAND			= 0,
			STATE_BODY_WALK				= 1,
			STATE_BODY_RUN				= 2,
			STATE_BODY_BACKSTEP			= 3,
			STATE_BODY_JUMP				= 4,
			STATE_BODY_FALLING			= 5,
			STATE_BODY_LANDING			= 6,
			STATE_BODY_DAMAGE_GROUND	= 7,
			STATE_BODY_DAMAGE_AIR		= 8,

			STATE_UPPER_STAND			= 9,
			STATE_UPPER_READY			= 10,
			STATE_UPPER_GUARD			= 11,

			STATE_ARML_STAND			= 12,
			STATE_ARML_PUNCH			= 13,

			STATE_ARMR_STAND			= 14,
			STATE_ARMR_PUNCH			= 15,

			STATE_ID_MAX				= 16,
		};

		enum BUTTON_ID
		{
			BUTTON_JUMP		= Mix::HID::GAMEPAD_A,
			BUTTON_BACKSTEP	= Mix::HID::GAMEPAD_B,
			BUTTON_READY	= Mix::HID::GAMEPAD_Y,
			BUTTON_GUARD	= Mix::HID::GAMEPAD_X,
			BUTTON_PUNCH_L	= Mix::HID::GAMEPAD_SHOULDER_LEFT,
			BUTTON_PUNCH_R	= Mix::HID::GAMEPAD_SHOULDER_RIGHT,
		};

		static const Float32 TRANSITION_RATIO_MIN;
		static const Float32 TRANSITION_RATIO_MAX;

		static const Float32 LF_STAND_TO_WALK;
		static const Float32 LF_WALK_TO_STAND;
		static const Float32 LF_WALK_TO_RUN;
		static const Float32 LF_RUN_TO_WALK;

		static const Float32 AERIAL_FRICTION;
		static const Float32 GROUND_FRICTION;

		static const Float32 GRAVITY;
		static const Float32 WALK_TO_JUMP_POWER;
		static const Float32 RUN_TO_JUMP_POWER;
		static const Float32 JUMP_XZ_ATTEN;
		static const Float32 JUMP_TO_FALLING_FRAME;
		static const Float32 JUMP_TO_FALLING_XZ_MAG;
		static const Float32 JUMP_TO_FALLING_Y;
		static const Float32 LANDING_ATTEN;
		static const Float32 GROUND_DAMAGE_VELOCITY;
		static const Float32 AERIAL_DAMAGE_VELOCITY;

		//Xe[g^XN
		class StateTask : public Utility::Motion::StateMachine::Task
		{
		protected:
			PlayableCharacter* m_pSubject;
			Utility::Motion::StateMachine::Channel* m_pChannel;

		public:
			StateTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel ) : m_pSubject( pSubject ), m_pChannel( pChannel ) {}
			virtual ~StateTask( void ) {}
		};

		typedef std::vector<Utility::Motion::StateMachine::Channel*> ChannelList;
		typedef std::vector<PlayableCharacter::StateTask*> StateTaskList;

		//ҋ@^XNNX
		class StandTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;
			Utility::Motion::StateMachine::State* m_pState;

		public:
			StandTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~StandTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//^XNNX
		class WalkTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;
			Utility::Motion::StateMachine::State* m_pState;

		public:
			WalkTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~WalkTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//^XNNX
		class RunTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;
			Utility::Motion::StateMachine::State* m_pState;

		public:
			RunTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~RunTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//obNXebv^XNNX
		class BackstepTask : public StateTask
		{
		private:
			Utility::Motion::StateMachine::State* m_pState;

		public:
			BackstepTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel );
			virtual ~BackstepTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//Wv^XNNX
		class JumpTask : public StateTask
		{
		private:
			Utility::Motion::StateMachine::State* m_pState;
			Mix::Vector3 m_InitalLinearVelocity;

		public:
			JumpTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel );
			virtual ~JumpTask( void );

		public:
			virtual void OnBegin( void );
			virtual void OnUpdate( Float32 dt );
		};

		//^XNNX
		class FallingTask : public StateTask
		{
		public:
			FallingTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel );
			virtual ~FallingTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//n^XNNX
		class LandingTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;
			Utility::Motion::StateMachine::State* m_pState;

		public:
			LandingTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~LandingTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//n_[W^XN
		class DamageGroundTask : public StateTask
		{
		private:
			Utility::Motion::StateMachine::State* m_pState;

		public:
			DamageGroundTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel );
			virtual ~DamageGroundTask( void );

		public:
			virtual void OnBegin( void );
			virtual void OnUpdate( Float32 dt );
		};

		//󒆃_[W^XN
		class DamageAirTask : public StateTask
		{
		private:
			Utility::Motion::StateMachine::State* m_pState;

		public:
			DamageAirTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel );
			virtual ~DamageAirTask( void );

		public:
			virtual void OnBegin( void );
			virtual void OnUpdate( Float32 dt );
		};

		//㔼g : ҋ@^XN
		class UpperStandTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;

		public:
			UpperStandTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~UpperStandTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//㔼g : \^XN
		class UpperReadyTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;

		public:
			UpperReadyTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~UpperReadyTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//㔼g : K[h^XN
		class UpperGuardTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;

		public:
			UpperGuardTask( PlayableCharacter* pSubject, Utility::Motion::StateMachine::Channel* pChannel, Mix::HID::IGamepad* pGamepad );
			virtual ~UpperGuardTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//r : ҋ@^XN
		class ArmStandTask : public StateTask
		{
		private:
			Mix::HID::IGamepad* m_pGamepad;
			Utility::Motion::StateMachine::Channel* m_pUpperChannel;
			UInt32 m_PunchButtonID;
			UInt32 m_PunchStateID;

		public:
			ArmStandTask(	PlayableCharacter* pSubject,
							Utility::Motion::StateMachine::Channel* pChannel,
							Utility::Motion::StateMachine::Channel* pUpperChannel,
							UInt32 standStateID,
							UInt32 punchStateID,
							UInt32 punchButtonID,
							Mix::HID::IGamepad* pGamepad );

			virtual ~ArmStandTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

		//r : p`^XN
		class ArmPunchTask : public StateTask
		{
		private:
			Utility::Motion::StateMachine::State* m_pState;
			Mix::HID::IGamepad* m_pGamepad;
			UInt32 m_PunchButtonID;
			UInt32 m_StandStateID;

		public:
			ArmPunchTask(	PlayableCharacter* pSubject,
							Utility::Motion::StateMachine::Channel* pChannel,
							const wchar_t* pMotionName,
							UInt32 standStateID,
							UInt32 punchStateID,
							UInt32 punchButtonID,
							Mix::HID::IGamepad* pGamepad );

			virtual ~ArmPunchTask( void );

		public:
			virtual void OnUpdate( Float32 dt );
		};

	private:
		Mix::Scene::IUniversalCamera* m_pCamera;
		Mix::HID::IGamepad* m_pGamepad;
		Mix::Scene::IActorModel* m_pModel;
		Mix::Scene::IMotionMixer* m_pMotionMixer;
		Mix::Scene::IActorKinematicCharacter* m_pKChar;
		Utility::Motion::StateMachine* m_pStateMachine;

		PlayableCharacter::StateTaskList m_StateTaskList;

	public:
		//! @brief RXgN^
		//! @param[in] pCamera J\ Mix::Scene::IUniversalCamera C^[tF[X̃|C^
		//! @param[in] pGamepad Q[pbh\ Mix::HID::IGamepad C^[tF[X̃|C^
		//! @param[in] pModel f\ Mix::Scene::IActorModel C^[tF[X̃|C^
		PlayableCharacter(	Mix::Scene::IUniversalCamera* pCamera,
							Mix::HID::IGamepad* pGamepad,
							Mix::Scene::IActorModel* pModel );

		//! @brief fXgN^
		virtual ~PlayableCharacter( void );

		//! @brief \[X܂
		void Dispose( void );

		//! @brief f̈ړx( [g[V )_Ci~NXɓKp܂
		//! @return Kpړx\ Mix::Vector3 NXԂ܂
		const Mix::Vector3& BakeIntoLinearVelocity( void );
		//! @brief ړxKp܂
		//! @param[in] vel ړx\ Mix::Vector3 NX
		void ApplyLinearVelocity( const Mix::Vector3& vel );
		//! @brief [J̈ړxKp܂
		//! @param[in] vel ړx\ Mix::Vector3 NX
		void ApplyLocalLinearVelocity( const Mix::Vector3& vel );

		//! @brief nĂ邩ǂmF܂
		//! @return nĂꍇ True Ԃ܂
		Boolean OnGround( void ) const;
		//! @brief Wv܂
		//! @note nĂȂ( OnGround() == False )ꍇ̓Wv܂B
		void Jump( void );

		//! @brief ANVv܂
		//! @param[in] type ^Cv\ PlayableCharacter::ACTION_TYPE 񋓒萔
		//! @param[in] pData ^CvŗL̃f[^̃|C^
		void Action( PlayableCharacter::ACTION_TYPE type, const void* pData = NULL );

	public:
		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const;

	public:
		//! @brief XV܂
		//! @param[in] dt f^^C
		virtual void OnUpdate( Float32 dt );
		//! @brief tbV܂
		virtual Boolean OnRefresh( void );
	};
}
