#include "Utility/UI/Button.h"
#include "Mix/Graphics.h"

namespace Utility{ namespace UI {

Button::Button( void )
{
	m_bDown = False;
}

Button::~Button( void )
{
}

void Button::SetText( const wchar_t* pText )
{
	m_Text = pText;
}

const wchar_t* Button::GetText( void ) const
{
	return m_Text.GetConstPtr();
}

void Button::Update( const Control::UPDATE_EVENT_ARGS& args )
{
	const Mix::Vector2& pos = GetPosition();
	const Mix::Vector2& size = GetSize();

	m_Rect.x = args.offset.x + pos.x;
	m_Rect.y = args.offset.y + pos.y;
	m_Rect.width = size.x;
	m_Rect.height = size.y;

	m_BackgroundRect.x = m_Rect.x + 1.0f;
	m_BackgroundRect.y = m_Rect.y + 1.0f;
	m_BackgroundRect.width = m_Rect.width - 2.0f;
	m_BackgroundRect.height = m_Rect.height - 2.0f;

	if( m_Text.GetNum() > 0 )
	{
		Mix::Vector2 textSize = Mix::Graphics::Utility::MeasureString( args.pFont, m_Text.GetConstPtr() );

		m_TextRect.x = m_BackgroundRect.x + 2.0f;
		m_TextRect.y = m_BackgroundRect.y + 2.0f;
		m_TextRect.width = m_BackgroundRect.width - 4.0f;
		m_TextRect.height = m_BackgroundRect.height - 4.0f;

		m_TextPos.x = ( m_TextRect.width  >= textSize.x )? ( m_TextRect.x + ( m_TextRect.width  - textSize.x ) * 0.5f ) : m_TextRect.x;
		m_TextPos.y = ( m_TextRect.height >= textSize.y )? ( m_TextRect.y + ( m_TextRect.height - textSize.y ) * 0.5f ) : m_TextRect.y;
	}
	else
	{
		m_TextPos = Mix::Vector2( 0.0f, 0.0f );
		m_TextRect = Mix::RectangleF( 0.0f, 0.0f, 0.0f, 0.0f );
	}
}

const Mix::RectangleF& Button::GetRectangle( void ) const
{
	return m_Rect;
}

void Button::OnMouseEnter( Mix::HID::IMouse* pMouse )
{
	if( ( IsFocus() == True ) &&
		( ( pMouse->GetButtonState( 0 ) & Mix::HID::DOWN ) == Mix::HID::DOWN ) )
	{
		m_bDown = True;
	}
}

void Button::OnMouseLeave( Mix::HID::IMouse* pMouse )
{
	m_bDown = False;
}

void Button::OnMouseDown( Mix::HID::IMouse* pMouse )
{
	m_bDown = True;
}

void Button::OnMouseUp( Mix::HID::IMouse* pMouse )
{
	if( m_bDown == True )
	{
		GetParent()->OnButton_Click( this );
		m_bDown = False;
	}
}

void Button::OnDraw( const Control::DRAW_EVENT_ARGS& args )
{
	args.pCanvasRenderer->SetColor( args.borderColor );
	args.pCanvasRenderer->AddRectangle( m_Rect );

	args.pCanvasRenderer->SetColor( ( m_bDown == True )? args.darkBackgroundColor : args.backgroundColor );
	args.pCanvasRenderer->AddFillRectangle( m_BackgroundRect );

	if( m_Text.GetNum() > 0 )
	{
		args.pCanvasRenderer->SetClip( m_TextRect );
		args.pCanvasRenderer->SetColor( args.textColor );
		args.pCanvasRenderer->AddString( m_TextPos, m_Text.GetConstPtr() );
	}
}

}}
