#pragma once

//! @file Utility/UI/Button.h
//! @brief {^NXCN[ht@C

#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

	//! @class Button
	//! @brief {^NX
	class Button : public UI::Control
	{
	private:
		Mix::RectangleF m_Rect;
		Mix::RectangleF m_BackgroundRect;

		Mix::StringW m_Text;
		Mix::Vector2 m_TextPos;
		Mix::RectangleF m_TextRect;

		Boolean m_bDown;

	public:
		//! @brief RXgN^
		Button( void );
		//! @brief fXgN^
		virtual ~Button( void );

		//! @brief eLXgݒ肵܂
		//! @param[in] pText eLXg
		void SetText( const wchar_t* pText );
		//! @brief eLXg擾܂
		//! @return eLXgԂ܂
		const wchar_t* GetText( void ) const;

	protected:
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args );
		virtual const Mix::RectangleF& GetRectangle( void ) const;

		virtual void OnMouseEnter( Mix::HID::IMouse* pMouse );
		virtual void OnMouseLeave( Mix::HID::IMouse* pMouse );
		virtual void OnMouseDown( Mix::HID::IMouse* pMouse );
		virtual void OnMouseUp( Mix::HID::IMouse* pMouse );
		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args );
	};
}}
