#pragma once

//! @file Utility/UI/CheckBox.h
//! @brief `FbN{bNXNXCN[ht@C

#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

	//! @class CheckBox
	//! @brief `FbN{bNXNX
	class CheckBox : public UI::Control
	{
	private:
		Mix::RectangleF m_Rect;
		Mix::RectangleF m_BackgroundRect;

		Mix::RectangleF m_BoxFrameRect;
		Mix::RectangleF m_BoxRect;
		Mix::RectangleF m_CheckRect;

		Mix::StringW m_Text;
		Mix::Vector2 m_TextPos;
		Mix::RectangleF m_TextRect;

		Boolean m_bCheck;
		Boolean m_bCheckDown;

	public:
		//! @brief RXgN^
		CheckBox( void );
		//! @brief fXgN^
		virtual ~CheckBox( void );

		//! @brief eLXgݒ肵܂
		//! @param[in] pText eLXg
		void SetText( const wchar_t* pText );
		//! @brief eLXg擾܂
		//! @return eLXgԂ܂
		const wchar_t* GetText( void ) const;

		//! @brief Xe[gݒ肵܂
		//! @param[in] state `FbNꍇ True
		void SetState( Boolean state );
		//! @brief Xe[g擾܂
		//! @return `FbNĂꍇ True Ԃ܂
		Boolean GetState( void ) const;

	protected:
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args );
		virtual const Mix::RectangleF& GetRectangle( void ) const;

		virtual void OnMouseDown( Mix::HID::IMouse* pMouse );
		virtual void OnMouseUp( Mix::HID::IMouse* pMouse );

		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args );
	};
}}
