#pragma once

//! @file Utility/UI/Color.h
//! @brief J[NXCN[ht@C

#include "Utility/UI/Control.h"

namespace Utility{ namespace UI {

	//! @class Color
	//! @brief J[NX
	class Color : public UI::Control
	{
	private:
		Mix::RectangleF m_Rect;
		Mix::RectangleF m_BackgroundRect;

		Mix::StringW m_Text;
		Mix::Vector2 m_TextPos;
		Mix::RectangleF m_TextRect;

		Boolean m_bAlphaEnabled;
		Mix::Vector4 m_Value;

	public:
		//! @brief RXgN^
		Color( void );
		//! @brief fXgN^
		virtual ~Color( void );

		//! @brief eLXgݒ肵܂
		//! @param[in] pText eLXg
		void SetText( const wchar_t* pText );
		//! @brief eLXg擾܂
		//! @return eLXgԂ܂
		const wchar_t* GetText( void ) const;

		//! @brief At@lLɂ邩ǂݒ肵܂
		//! @param[in] state At@lLɂꍇ True
		void SetAlphaEnabled( Boolean state );
		//! @brief At@lLǂ擾܂
		//! @return At@lLȏꍇ True Ԃ܂
		Boolean GetAlphaEnabled( void ) const;

		//! @brief Fݒ肵܂
		//! @param[in] value F
		void SetValue( const Mix::Vector4& value );
		//! @brief F擾܂
		//! @return FԂ܂
		const Mix::Vector4& GetValue( void ) const;

	protected:
		virtual void Update( const Control::UPDATE_EVENT_ARGS& args );
		virtual const Mix::RectangleF& GetRectangle( void ) const;

		virtual void OnDraw( const Control::DRAW_EVENT_ARGS& args );

	private:
		static const Float32 TILE_SIZE;
	};
}}
